/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.documentexchange;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.Client;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.constant.XMLNamespaces;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.handler.ConfigurableMTOMHandler;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.CodedValue;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.ConfidentialityCodes;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.DocumentMetadata;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.SubmissionMetadata;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.DateUtils;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.FileUtils;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.MetadataUtils;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.XDSMapper;
import au.gov.nehta.xsp.CertificateValidator;
import au.net.electronichealth.ns.pcehr.xsd.common.commoncoreelements._1.PCEHRHeader;
import ihe.iti.xds_b._2007.DocumentRepositoryPortType;
import ihe.iti.xds_b._2007.DocumentRepositoryService;
import ihe.iti.xds_b._2007.ProvideAndRegisterDocumentSetRequest;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.ws.Holder;
import javax.xml.xpath.XPathExpressionException;
import oasis.names.tc.ebxml_regrep.xsd.lcm._3.SubmitObjectsRequest;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.RegistryResponseType;
import org.apache.commons.lang.Validate;
import org.xml.sax.SAXException;

public final class UploadDocumentClient
extends Client<DocumentRepositoryPortType> {
    public UploadDocumentClient(SSLSocketFactory sSLSocketFactory, X509Certificate x509Certificate, PrivateKey privateKey, String string, boolean bl) {
        super(DocumentRepositoryService.class, DocumentRepositoryPortType.class, sSLSocketFactory, x509Certificate, privateKey, string, bl, new ConfigurableMTOMHandler("ProvideAndRegisterDocumentSetRequest", XMLNamespaces.IHE.getNamespace(), "Document"));
    }

    public UploadDocumentClient(SSLSocketFactory sSLSocketFactory, X509Certificate x509Certificate, CertificateValidator certificateValidator, PrivateKey privateKey, String string, boolean bl) {
        super(DocumentRepositoryService.class, DocumentRepositoryPortType.class, sSLSocketFactory, x509Certificate, certificateValidator, privateKey, string, bl, new ConfigurableMTOMHandler("ProvideAndRegisterDocumentSetRequest", XMLNamespaces.IHE.getNamespace(), "Document"));
    }

    public RegistryResponseType uploadDocument(PCEHRHeader pCEHRHeader, byte[] byArray, CodedValue codedValue, CodedValue codedValue2, CodedValue codedValue3) throws IOException, SAXException, XPathExpressionException, ParserConfigurationException {
        return this.uploadDocument(pCEHRHeader, byArray, null, codedValue, codedValue2, codedValue3);
    }

    public RegistryResponseType uploadDocument(PCEHRHeader pCEHRHeader, byte[] byArray, String string, CodedValue codedValue, CodedValue codedValue2, CodedValue codedValue3) throws XPathExpressionException, IOException, SAXException, ParserConfigurationException {
        return this.uploadDocument(pCEHRHeader, byArray, string, null, codedValue, codedValue2, codedValue3);
    }

    public RegistryResponseType uploadDocument(PCEHRHeader pCEHRHeader, byte[] byArray, String string, String string2, CodedValue codedValue, CodedValue codedValue2, CodedValue codedValue3) throws IOException, SAXException, XPathExpressionException, ParserConfigurationException {
        Validate.notNull((Object)byArray, (String)"'packageContent' must be specified");
        Validate.notNull((Object)codedValue, (String)"'healthcareFacilityType' must be specified");
        Validate.notNull((Object)codedValue2, (String)"'practiceSettingTypeCode' must be specified");
        Validate.notNull((Object)codedValue3, (String)"'formatCode' must be specified");
        byte[] byArray2 = FileUtils.getCdaDocument(byArray);
        DocumentMetadata documentMetadata = MetadataUtils.toDocumentMetadata(pCEHRHeader, byArray2);
        documentMetadata.setHealthcareFacilityType(codedValue);
        documentMetadata.setPracticeSetting(codedValue2);
        documentMetadata.setConfidentialityCode(ConfidentialityCodes.NA);
        documentMetadata.setEntryUuid("DOCUMENT_SYMBOLICID_01");
        documentMetadata.setFormatCode(codedValue3);
        if (string2 != null) {
            documentMetadata.setRepositoryUniqueId(string2);
            documentMetadata.setDocumentHash(MetadataUtils.calculateSha1Hash(byArray));
            documentMetadata.setDocumentSize(new BigInteger(String.valueOf(byArray.length)));
        }
        SubmissionMetadata submissionMetadata = new SubmissionMetadata();
        submissionMetadata.setSubmissionTime(new Date());
        submissionMetadata.setEntryUuid("SUBSET_SYMBOLICID_01");
        SubmitObjectsRequest submitObjectsRequest = XDSMapper.toSubmitObjectsRequest(pCEHRHeader, submissionMetadata, documentMetadata, string);
        ProvideAndRegisterDocumentSetRequest.Document document = new ProvideAndRegisterDocumentSetRequest.Document();
        document.setId(documentMetadata.getEntryUuid());
        document.setValue(byArray);
        ProvideAndRegisterDocumentSetRequest provideAndRegisterDocumentSetRequest = new ProvideAndRegisterDocumentSetRequest();
        provideAndRegisterDocumentSetRequest.setSubmitObjectsRequest(submitObjectsRequest);
        provideAndRegisterDocumentSetRequest.getDocuments().add(document);
        Holder holder = null;
        return ((DocumentRepositoryPortType)this.getPort()).documentRepositoryProvideAndRegisterDocumentSetB(DateUtils.generateTimestamp(), holder, pCEHRHeader, provideAndRegisterDocumentSetRequest);
    }
}

