/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.type;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum DocumentStatus {
    SUBMITTED("urn:oasis:names:tc:ebxml-regrep:StatusType:Submitted"),
    APPROVED("urn:oasis:names:tc:ebxml-regrep:StatusType:Approved"),
    DELETED("urn:orcl.reg:names:StatusType:Deleted"),
    DEPRECATED("urn:oasis:names:tc:ebxml-regrep:StatusType:Deprecated");

    private static final Map<String, DocumentStatus> CODE_MAP;
    private final String code;

    private DocumentStatus(String string2) {
        this.code = string2;
    }

    public String getCode() {
        return this.code;
    }

    public static DocumentStatus fromCode(String string) {
        if (!CODE_MAP.containsKey(string)) {
            throw new IllegalArgumentException("'" + string + "' is not a valid DocumentStatus code.");
        }
        return CODE_MAP.get(string);
    }

    static {
        CODE_MAP = new HashMap<String, DocumentStatus>();
        for (DocumentStatus documentStatus : EnumSet.allOf(DocumentStatus.class)) {
            CODE_MAP.put(documentStatus.getCode(), documentStatus);
        }
    }
}

