/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.ws.handler;

import au.gov.nehta.vendorlibrary.xml.XmlUtil;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public final class LoggingHandler
implements SOAPHandler<SOAPMessageContext> {
    public static final String EMPTY = "";
    public static final String ENCODING = "utf-8";
    private static final Logger LOG = Logger.getLogger(LoggingHandler.class.getName());
    private String lastSoapRequest;
    private String lastSoapResponse;
    private boolean dump;

    public LoggingHandler(boolean bl) {
        this.dump = bl;
    }

    public String getLastSoapResponse() {
        return this.lastSoapResponse;
    }

    public String getLastSoapRequest() {
        return this.lastSoapRequest;
    }

    public boolean handleMessage(SOAPMessageContext sOAPMessageContext) {
        this.logSOAPMessage(sOAPMessageContext);
        return true;
    }

    public boolean handleFault(SOAPMessageContext sOAPMessageContext) {
        this.logSOAPMessage(sOAPMessageContext);
        return true;
    }

    private void logSOAPMessage(SOAPMessageContext sOAPMessageContext) {
        boolean bl = (Boolean)sOAPMessageContext.get((Object)"javax.xml.ws.handler.message.outbound");
        if (bl) {
            this.lastSoapRequest = XmlUtil.serialiseSoapXml(sOAPMessageContext.getMessage());
            if (this.dump) {
                LOG.info("Outgoing" + this.lastSoapRequest);
            }
        } else {
            this.lastSoapResponse = XmlUtil.serialiseSoapXml(sOAPMessageContext.getMessage());
            if (this.dump) {
                LOG.info("Incoming" + this.lastSoapResponse);
            }
        }
    }

    public Set<QName> getHeaders() {
        return Collections.emptySet();
    }

    public void close(MessageContext messageContext) {
    }
}

