/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.common;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.common.utils.JaxbUtils;
import au.gov.nehta.vendorlibrary.common.DOMUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;

public final class JAXBUtil {
    private static final Logger LOG = Logger.getLogger(JAXBUtil.class.getName());

    private JAXBUtil() {
    }

    public static <T> String marshaller(Class clazz, String string, String string2, T t) throws JAXBException {
        ArgumentUtils.checkNotNull((Object)clazz, (String)"instanceClass");
        ArgumentUtils.checkNotNull((Object)string2, (String)"className");
        ArgumentUtils.checkNotNull(t, (String)"object");
        String string3 = string;
        if (string3 == null) {
            string3 = "";
        }
        QName qName = new QName(string3, string2);
        return JaxbUtils.marshalToString((JAXBElement)new JAXBElement(qName, clazz, t));
    }

    public static <T> String marshaller(Class clazz, String string, T t) throws JAXBException {
        return JAXBUtil.marshaller(clazz, null, string, t);
    }

    public static <T> T unmarshaller(Class clazz, String string) throws JAXBException {
        ArgumentUtils.checkNotNull((Object)clazz, (String)"parameterObject");
        ArgumentUtils.checkNotNull((Object)string, (String)"xmlSource");
        ByteArrayInputStream byteArrayInputStream = null;
        Object object = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
            if (byteArrayInputStream != null) {
                object = JaxbUtils.unmarshal((Reader)new InputStreamReader(byteArrayInputStream), (Class)clazz);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new JAXBException("Unsupported encoding format", (Throwable)unsupportedEncodingException);
        }
        finally {
            try {
                if (byteArrayInputStream != null) {
                    ((InputStream)byteArrayInputStream).close();
                }
            }
            catch (IOException iOException) {
                throw new JAXBException((Throwable)iOException);
            }
        }
        return (T)object;
    }

    public static <T> T unmarshaller(Class clazz, Document document) throws JAXBException {
        ArgumentUtils.checkNotNull((Object)clazz, (String)"parameterObject");
        ArgumentUtils.checkNotNull((Object)document, (String)"doc");
        document.normalizeDocument();
        try {
            return JAXBUtil.unmarshaller(clazz, DOMUtil.serialiseToString(document));
        }
        catch (TransformerException transformerException) {
            throw new JAXBException("Failed to serialise DOM to XML string data", (Throwable)transformerException);
        }
        catch (IOException iOException) {
            throw new JAXBException("Failed to serialise DOM to XML string data", (Throwable)iOException);
        }
    }
}

