/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.common.security;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.vendorlibrary.common.security.EncryptedContainerProfileUtil;
import au.gov.nehta.vendorlibrary.common.security.SignedContainerProfileUtil;
import au.gov.nehta.xsp.XspException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.SecretKey;
import javax.security.auth.x500.X500PrivateCredential;
import org.w3c.dom.Document;

public final class SignedEncryptedContainerProfileUtil {
    private SignedEncryptedContainerProfileUtil() {
    }

    public static Document getSignedEncryptedPayload(String string, List<X500PrivateCredential> list, X509Certificate x509Certificate) throws XspException {
        ArgumentUtils.checkNotNullNorBlank((String)string, (String)"sensitivePayload");
        ArgumentUtils.checkNotNull(list, (String)"certificateKeyPairs");
        ArgumentUtils.checkNotNull((Object)x509Certificate, (String)"encryptingCert");
        Document document = SignedContainerProfileUtil.getSignedPayload(string, list);
        Document document2 = EncryptedContainerProfileUtil.getEncryptedPayload(document, x509Certificate);
        return document2;
    }

    public static Document getSignedEncryptedPayload(String string, SecretKey secretKey, List<X500PrivateCredential> list, List<X509Certificate> list2) throws XspException {
        ArgumentUtils.checkNotNullNorBlank((String)string, (String)"sensitivePayload");
        ArgumentUtils.checkNotNull((Object)secretKey, (String)"sessionKey");
        ArgumentUtils.checkNotNull(list, (String)"certificateKeyPairs");
        ArgumentUtils.checkNotNull(list2, (String)"encryptingCertificates");
        Document document = null;
        Document document2 = SignedContainerProfileUtil.getSignedPayload(string, list);
        document = EncryptedContainerProfileUtil.getEncryptedPayload(document2, secretKey, list2);
        return document;
    }

    public static Document getSignedEncryptedPayload(String string, SecretKey secretKey, List<X500PrivateCredential> list, X509Certificate x509Certificate) throws XspException {
        ArgumentUtils.checkNotNull((Object)x509Certificate, (String)"encryptingCert");
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        arrayList.add(x509Certificate);
        return SignedEncryptedContainerProfileUtil.getSignedEncryptedPayload(string, secretKey, list, arrayList);
    }

    public static Document getDataFromSignedEncryptedPayload(Document document, X500PrivateCredential x500PrivateCredential) throws XspException {
        ArgumentUtils.checkNotNull((Object)document, (String)"signedEncryptedPayload");
        ArgumentUtils.checkNotNull((Object)x500PrivateCredential, (String)"privateCredential");
        Document document2 = EncryptedContainerProfileUtil.getDecryptedPayload(document, x500PrivateCredential);
        Document document3 = SignedContainerProfileUtil.getDataFromSignedPayload(document2);
        return document3;
    }
}

