/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.xsp.impl.v1;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.common.utils.DomUtils;
import au.gov.nehta.xsp.EncryptedContainerProfileService;
import au.gov.nehta.xsp.KeyMismatchException;
import au.gov.nehta.xsp.XmlEncryptionProfileService;
import au.gov.nehta.xsp.XspException;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.crypto.SecretKey;
import javax.security.auth.x500.X500PrivateCredential;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EncryptedContainerProfileServiceImpl
implements EncryptedContainerProfileService {
    private final String encryptedPayloadXmlns;
    private final XmlEncryptionProfileService xmlEncService;

    public EncryptedContainerProfileServiceImpl(String encryptedPayloadXmlns, XmlEncryptionProfileService xmlEncService) {
        ArgumentUtils.checkNotNullNorBlank((String)encryptedPayloadXmlns, (String)"encryptedPayloadXmlns");
        ArgumentUtils.checkNotNull((Object)xmlEncService, (String)"xmlEncService");
        this.encryptedPayloadXmlns = encryptedPayloadXmlns;
        this.xmlEncService = xmlEncService;
    }

    @Override
    public Document create(Document payloadDoc, X509Certificate certificate) throws XspException {
        DomUtils.checkNotNullOrEmpty((Document)payloadDoc, (String)"payloadDoc");
        ArgumentUtils.checkNotNull((Object)certificate, (String)"certificate");
        return this.create(payloadDoc, Arrays.asList(certificate));
    }

    @Override
    public Document create(Document payloadDoc, List<X509Certificate> certificates) throws XspException {
        DomUtils.checkNotNullOrEmpty((Document)payloadDoc, (String)"payloadDoc");
        ArgumentUtils.checkNotNullNorEmpty(certificates, (String)"certificates");
        Document clonePayloadDoc = (Document)payloadDoc.cloneNode(true);
        clonePayloadDoc.normalizeDocument();
        Document containerDoc = null;
        try {
            containerDoc = DomUtils.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new XspException("Couldn't create the encrypted payload container XML document.", e);
        }
        Element encryptedPayloadElem = containerDoc.createElementNS(this.encryptedPayloadXmlns, "ep:encryptedPayload");
        containerDoc.appendChild(encryptedPayloadElem);
        Element keysElem = containerDoc.createElementNS(this.encryptedPayloadXmlns, "ep:keys");
        encryptedPayloadElem.appendChild(keysElem);
        Element encyptedPayloadDataElem = containerDoc.createElementNS(this.encryptedPayloadXmlns, "ep:encryptedPayloadData");
        encryptedPayloadElem.appendChild(encyptedPayloadDataElem);
        Element rootPayloadElem = clonePayloadDoc.getDocumentElement();
        Element importedPayloadElem = (Element)containerDoc.importNode(rootPayloadElem, true);
        encyptedPayloadDataElem.appendChild(importedPayloadElem);
        this.xmlEncService.encrypt(keysElem, importedPayloadElem, certificates);
        return containerDoc;
    }

    @Override
    public Document create(Document payloadDoc, SecretKey sessionKey, X509Certificate certificate) throws XspException {
        DomUtils.checkNotNullOrEmpty((Document)payloadDoc, (String)"payloadDoc");
        ArgumentUtils.checkNotNull((Object)sessionKey, (String)"sessionKey");
        ArgumentUtils.checkNotNull((Object)certificate, (String)"certificate");
        return this.create(payloadDoc, sessionKey, Arrays.asList(certificate));
    }

    @Override
    public Document create(Document payloadDoc, SecretKey sessionKey, List<X509Certificate> certificates) throws XspException {
        DomUtils.checkNotNullOrEmpty((Document)payloadDoc, (String)"payloadDoc");
        ArgumentUtils.checkNotNull((Object)sessionKey, (String)"sessionKey");
        ArgumentUtils.checkNotNullNorEmpty(certificates, (String)"certificates");
        Document clonePayloadDoc = (Document)payloadDoc.cloneNode(true);
        clonePayloadDoc.normalizeDocument();
        Document containerDoc = null;
        try {
            containerDoc = DomUtils.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new XspException("Couldn't create the encrypted payload container XML document.", e);
        }
        Element encryptedPayloadElem = containerDoc.createElementNS(this.encryptedPayloadXmlns, "ep:encryptedPayload");
        containerDoc.appendChild(encryptedPayloadElem);
        Element keysElem = containerDoc.createElementNS(this.encryptedPayloadXmlns, "ep:keys");
        encryptedPayloadElem.appendChild(keysElem);
        Element encyptedPayloadDataElem = containerDoc.createElementNS(this.encryptedPayloadXmlns, "ep:encryptedPayloadData");
        encryptedPayloadElem.appendChild(encyptedPayloadDataElem);
        Element rootPayloadElem = clonePayloadDoc.getDocumentElement();
        Element importedPayloadElem = (Element)containerDoc.importNode(rootPayloadElem, true);
        encyptedPayloadDataElem.appendChild(importedPayloadElem);
        this.xmlEncService.encrypt(keysElem, importedPayloadElem, sessionKey, certificates);
        return containerDoc;
    }

    @Override
    public Document getData(Document encryptedPayloadDoc, X500PrivateCredential credential) throws KeyMismatchException, XspException {
        DomUtils.checkNotNullOrEmpty((Document)encryptedPayloadDoc, (String)"encryptedPayloadDoc");
        ArgumentUtils.checkNotNull((Object)credential, (String)"credential");
        return this.getData(encryptedPayloadDoc.getDocumentElement(), credential);
    }

    @Override
    public Document getData(Element encryptedPayloadElem, X500PrivateCredential credential) throws KeyMismatchException, XspException {
        ArgumentUtils.checkNotNull((Object)encryptedPayloadElem, (String)"encryptedPayloadElem");
        DomUtils.checkElement((Element)encryptedPayloadElem, (String)"encryptedPayload", (String)this.encryptedPayloadXmlns);
        ArgumentUtils.checkNotNull((Object)credential, (String)"credential");
        Element clonedPayloadElem = (Element)encryptedPayloadElem.cloneNode(true);
        Element keysElem = DomUtils.getChildElement((Element)clonedPayloadElem, (String)this.encryptedPayloadXmlns, (String)"keys");
        List encryptedKeyElems = DomUtils.getChildElements((Element)keysElem, (String)"http://www.w3.org/2001/04/xmlenc#", (String)"EncryptedKey");
        Element encryptedPayloadDataElem = DomUtils.getChildElement((Element)clonedPayloadElem, (String)this.encryptedPayloadXmlns, (String)"encryptedPayloadData");
        Element encryptedDataElem = DomUtils.getChildElement((Element)encryptedPayloadDataElem, (String)"http://www.w3.org/2001/04/xmlenc#", (String)"EncryptedData");
        this.xmlEncService.decrypt((List<Element>)encryptedKeyElems, encryptedDataElem, credential);
        encryptedPayloadDataElem = DomUtils.getChildElement((Element)clonedPayloadElem, (String)this.encryptedPayloadXmlns, (String)"encryptedPayloadData");
        Element payloadElem = DomUtils.getFirstChildElement((Node)encryptedPayloadDataElem);
        try {
            return DomUtils.newDocument((Node)payloadElem);
        }
        catch (ParserConfigurationException ex) {
            throw new XspException("Couldn't create new document containing the payload.", ex);
        }
    }

    @Override
    public Document getData(Document encryptedPayloadDoc, SecretKey sessionKey) throws KeyMismatchException, XspException {
        DomUtils.checkNotNullOrEmpty((Document)encryptedPayloadDoc, (String)"encryptedPayloadDoc");
        ArgumentUtils.checkNotNull((Object)sessionKey, (String)"sessionKey");
        return this.getData(encryptedPayloadDoc.getDocumentElement(), sessionKey);
    }

    @Override
    public Document getData(Element encryptedPayloadElem, SecretKey sessionKey) throws KeyMismatchException, XspException {
        ArgumentUtils.checkNotNull((Object)encryptedPayloadElem, (String)"encryptedPayloadElem");
        DomUtils.checkElement((Element)encryptedPayloadElem, (String)"encryptedPayload", (String)this.encryptedPayloadXmlns);
        ArgumentUtils.checkNotNull((Object)sessionKey, (String)"sessionKey");
        Element clonedPayloadElem = (Element)encryptedPayloadElem.cloneNode(true);
        Element keysElem = DomUtils.getChildElement((Element)clonedPayloadElem, (String)this.encryptedPayloadXmlns, (String)"keys");
        List encryptedKeyElems = DomUtils.getChildElements((Element)keysElem, (String)"http://www.w3.org/2001/04/xmlenc#", (String)"EncryptedKey");
        Element encryptedPayloadDataElem = DomUtils.getChildElement((Element)clonedPayloadElem, (String)this.encryptedPayloadXmlns, (String)"encryptedPayloadData");
        Element encryptedDataElem = DomUtils.getChildElement((Element)encryptedPayloadDataElem, (String)"http://www.w3.org/2001/04/xmlenc#", (String)"EncryptedData");
        this.xmlEncService.decrypt((List<Element>)encryptedKeyElems, encryptedDataElem, sessionKey);
        encryptedPayloadDataElem = DomUtils.getChildElement((Element)clonedPayloadElem, (String)this.encryptedPayloadXmlns, (String)"encryptedPayloadData");
        Element payloadElem = DomUtils.getFirstChildElement((Node)encryptedPayloadDataElem);
        try {
            return DomUtils.newDocument((Node)payloadElem);
        }
        catch (ParserConfigurationException ex) {
            throw new XspException("Couldn't create new document containing the payload.", ex);
        }
    }

    @Override
    public Key getSessionKey(Element encryptedPayloadElem, X500PrivateCredential credential) throws KeyMismatchException, XspException {
        ArgumentUtils.checkNotNull((Object)encryptedPayloadElem, (String)"encryptedPayloadElem");
        ArgumentUtils.checkNotNull((Object)credential, (String)"credential");
        Element clonedPayloadElem = (Element)encryptedPayloadElem.cloneNode(true);
        List<Element> encryptedKeyElems = this.getEncryptedKeyElements(clonedPayloadElem);
        Element encryptedDataElem = this.getEncryptedDataElement(clonedPayloadElem);
        return this.xmlEncService.getSessionKey(encryptedKeyElems, encryptedDataElem, credential);
    }

    @Override
    public Key getSessionKey(Document encryptedPayloadDoc, X500PrivateCredential credential) throws KeyMismatchException, XspException {
        return this.getSessionKey(encryptedPayloadDoc.getDocumentElement(), credential);
    }

    @Override
    public List<X509Certificate> getEncryptingCertificates(Element encryptedPayloadElem, KeyStore keyStore) throws XspException {
        ArgumentUtils.checkNotNull((Object)encryptedPayloadElem, (String)"encryptedPayloadElem");
        ArgumentUtils.checkNotNull((Object)keyStore, (String)"keyStore");
        Element clonedPayloadElem = (Element)encryptedPayloadElem.cloneNode(true);
        List<Element> encryptedKeyElems = this.getEncryptedKeyElements(clonedPayloadElem);
        return this.xmlEncService.getEncryptingCertificates(encryptedKeyElems, keyStore);
    }

    @Override
    public List<X509Certificate> getEncryptingCertificates(Document encryptedPayloadDoc, KeyStore keyStore) throws XspException {
        ArgumentUtils.checkNotNull((Object)encryptedPayloadDoc, (String)"encryptedPayloadDoc");
        return this.getEncryptingCertificates(encryptedPayloadDoc.getDocumentElement(), keyStore);
    }

    @Override
    public boolean isEncryptingCertificate(Element encryptedPayloadElem, X509Certificate certificate) throws XspException {
        ArgumentUtils.checkNotNull((Object)encryptedPayloadElem, (String)"encryptedPayloadElem");
        DomUtils.checkElement((Element)encryptedPayloadElem, (String)"encryptedPayload", (String)this.encryptedPayloadXmlns);
        ArgumentUtils.checkNotNull((Object)certificate, (String)"certificate");
        Element clonedPayloadElem = (Element)encryptedPayloadElem.cloneNode(true);
        List<Element> encryptedKeyElems = this.getEncryptedKeyElements(clonedPayloadElem);
        return this.xmlEncService.isEncryptingCertificate(encryptedKeyElems, certificate);
    }

    @Override
    public boolean isEncryptingCertificate(Document encryptedPayloadDoc, X509Certificate certificate) throws XspException {
        ArgumentUtils.checkNotNull((Object)encryptedPayloadDoc, (String)"encryptedPayloadDoc");
        ArgumentUtils.checkNotNull((Object)certificate, (String)"certificate");
        return this.isEncryptingCertificate(encryptedPayloadDoc.getDocumentElement(), certificate);
    }

    private List<Element> getEncryptedKeyElements(Element encryptedPayloadElem) {
        Element keysElem = DomUtils.getChildElement((Element)encryptedPayloadElem, (String)this.encryptedPayloadXmlns, (String)"keys");
        return DomUtils.getChildElements((Element)keysElem, (String)"http://www.w3.org/2001/04/xmlenc#", (String)"EncryptedKey");
    }

    private Element getEncryptedDataElement(Element encryptedPayloadElem) {
        Element encryptedPayloadDataElem = DomUtils.getChildElement((Element)encryptedPayloadElem, (String)this.encryptedPayloadXmlns, (String)"encryptedPayloadData");
        return DomUtils.getChildElement((Element)encryptedPayloadDataElem, (String)"http://www.w3.org/2001/04/xmlenc#", (String)"EncryptedData");
    }
}

