﻿using HIPS.Web.Components.Common;

namespace HIPS.Web.Components.ServiceModel
{
    /// <summary>
    /// Represents a textual response message.
    /// </summary>
    public class ResponseMessage
    {
        #region Properties

        /// <summary>
        /// Gets or sets the level associated with the message.
        /// </summary>
        public MessageLevel Level { get; set; }

        /// <summary>
        /// Gets or sets the description text for the message.
        /// </summary>
        public string Description { get; set; }

        #endregion Properties

        #region Constructors

        /// <summary>
        /// Constructor.
        /// </summary>
        public ResponseMessage()
        {
        }

        /// <summary>
        /// Creates a new response message.
        /// </summary>
        /// <param name="description">Description text for the message.</param>
        /// <param name="level">Level associated with the message.</param>
        public ResponseMessage(string description, MessageLevel level)
            : this()
        {
            this.Description = description;
            this.Level = level;
        }

        #endregion Constructors
    }
}