﻿using AutoMapper;

using CommonSchema = HIPS.Web.Components.ServiceModel;
using ServiceSchema = HIPS.ServiceContracts.Common.DTO;

namespace HIPS.Web.Data.Hips.Mapping.Profiles
{
    internal class MessageProfile : Profile
    {
        public override string ProfileName
        {
            get { return this.GetType().Name; }
        }

        protected override void Configure()
        {
            this.CreateMap<ServiceSchema.Message, CommonSchema.ResponseMessage>()
                    .ForMember(dest => dest.Description, opt => opt.MapFrom(src => string.Format("{0} [Code: {1}; Origin: {2}]", src.Description, src.Code, src.Origin)))
                    .ForMember(dest => dest.Level, opt => opt.MapFrom(src => this.TransformMessageLevel(src.Level)));
        }

        /// <summary>
        /// Transform between MessageLevel enumerations.
        /// </summary>
        /// <param name="src">Source MessageLevel.</param>
        /// <returns>Target MessageLevel.</returns>
        private HIPS.Web.Components.Common.MessageLevel TransformMessageLevel(HIPS.ServiceContracts.Common.MessageLevel src)
        {
            switch (src)
            {
                case HIPS.ServiceContracts.Common.MessageLevel.None:
                case HIPS.ServiceContracts.Common.MessageLevel.Information:
                    {
                        return HIPS.Web.Components.Common.MessageLevel.Information;
                    }
                case HIPS.ServiceContracts.Common.MessageLevel.Warning:
                    {
                        return HIPS.Web.Components.Common.MessageLevel.Warning;
                    }
                case HIPS.ServiceContracts.Common.MessageLevel.Error:
                    {
                        return HIPS.Web.Components.Common.MessageLevel.Error;
                    }
                default:
                    {
                        return Components.Common.MessageLevel.Information;
                    }
            }
        }
    }
}