﻿using HIPS.Web.Model.PatientIdentifier;

namespace HIPS.Web.Model.Cda
{
    public class CdaDocumentDetails
    {
        /// <summary>
        /// Gets or sets the CDA document.
        /// </summary>
        public CdaDocument Document { get; set; }

        /// <summary>
        /// Gets or sets a patient identifier of the same type that was specified in the request.
        /// </summary>
        public PatientIdentifierBase PatientIdentifier { get; set; }

        /// <summary>
        /// Gets or sets the document set identifier used when creating the CDA document.
        /// </summary>
        public string DocumentSetId { get; set; }

        /// <summary>
        /// Gets or sets the document identifier used when creating the CDA document.
        /// </summary>
        public string DocumentId { get; set; }

        /// <summary>
        /// Gets or sets the MRN number of the patient at the hospital that is
        /// specified in the patient identifier. If the MRN was auto-generated
        /// by HIPS then that value (which is based on a GUID) will be returned,
        /// otherwise it will be the MRN that was passed in the HL7 message to
        /// the Database Loader.
        /// </summary>
        public string Mrn { get; set; }
    }
}