﻿namespace HIPS.Web.Model.ParticipatingIndividual
{
    public class ParticipatingProvider
    {
        /// <summary>
        /// Gets or sets the validated HPI-I of the participating provider. For
        /// the document author and responsible health professional, this is
        /// conditionally mandatory with the Local Identifier as at least one
        /// must be specified. If both are specified then the HPI-I will take
        /// precedence over the Local Identifier.
        /// </summary>
        public string Hpii { get; set; }

        /// <summary>
        /// Gets or sets the HPI-O of the organisation that employs the participant.
        /// If the employer HPI-O is specified then the employer name must also.
        /// If neither are specified, the HPI-O and name of the hospital will be used.
        /// </summary>
        public string EmployerHpio { get; set; }

        /// <summary>
        /// Gets or sets the name of the organisation that employs the participant.
        /// If the employer HPI-O is specified then the employer name must also.
        /// If neither are specified, the HPI-O and name of the hospital will be used.
        /// </summary>
        public string EmployerName { get; set; }

        /// <summary>
        /// Gets or sets the name title of the participating individual.
        /// </summary>
        public string Title { get; set; }

        /// <summary>
        /// Gets or sets the family name of the participating individual.
        /// </summary>
        public string FamilyName { get; set; }

        /// <summary>
        /// Gets or sets the given names of the participating individual. If
        /// there are multiple given names, they should be separated by spaces.
        /// </summary>
        public string GivenNames { get; set; }

        /// <summary>
        /// Gets or sets the name suffix of the participating individual.
        /// </summary>
        public string Suffix { get; set; }

        /// <summary>
        /// Gets or sets the unique local identifier of the participating
        /// individual. The local identifier must be unique within the
        /// authoring organisation (HPI-O). For the document author and
        /// responsible health professional, this is conditionally mandatory
        /// with the HPI-I as at least one must be specified.
        /// </summary>
        public string LocalIdentifier { get; set; }
    }
}