using System;
using System.Collections.Generic;
using HIPS.PcehrDataStore.Schemas;

namespace HIPS.Web.ModelInterface.Common
{
    /// <summary>
    /// Defines the operations to be supported by an implementation of a hospital repository.
    /// </summary>
    public interface IHospitalRepository : IDisposable
    {
        /// <summary>
        /// Lists the hospitals that have a code in the given code system.
        /// </summary>
        /// <param name="hospitalCodeSystem">The code system.</param>
        /// <returns>List of hospitals.</returns>
        List<Hospital> GetHospitals(string hospitalCodeSystem);

        /// <summary>
        /// List the hospitals that are accessible to the user from security groups
        /// </summary>
        /// <param name="accessibleGroupNames">List of Security Groups the user is a member of</param>
        /// <param name="securityGroupCodeSystem">The SecurityGroupCodeSystem</param>
        /// <returns>List of hospitals the user has access to.</returns>
        List<Hospital> GetAccessibleHospitals(List<string> accessibleGroupNames, string securityGroupCodeSystem);
    }
}