﻿namespace HIPS.Web.ModelInterface.Common
{
    /// <summary>
    /// Interface for providing management of session-based temporary data.
    /// </summary>
    public interface ISessionProvider
    {
        #region Methods

        /// <summary>
        /// Get the value identified by the specified key from the session store.
        /// </summary>
        /// <param name="key">Key used to identify the value to retrieve from the session store.</param>
        /// <returns>Value identified by the key if available in the session store, null otherwise.</returns>
        object Get(string key);

        /// <summary>
        /// Set the value in the session store using the specified key.
        /// </summary>
        /// <param name="key">Key used to identify the item when inserted into the session store.</param>
        /// <param name="value">Value to insert into the session store.</param>
        void Set(string key, object value);

        #endregion Methods
    }
}