﻿#region Using Statements

using System;

#endregion Using Statements

namespace HIPS.Web.UI.Filters
{
    /// <summary>
    /// Provides an action filter attribute that supports checking access to the PCEHR.
    /// </summary>
    public class PcehrAccessAttribute : Attribute
    {
        #region Properties

        /// <summary>
        /// Gets or sets a Boolean value that indicates whether to automatically attempt to gain access if required.
        /// </summary>
        public bool AutoAccess { get; set; }

        #endregion Properties

        #region Constructors

        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="autoAccess">A Boolean value that indicates whether to automatically attempt to gain access if required. Defaults to true.</param>
        public PcehrAccessAttribute(bool autoAccess = true)
        {
            this.AutoAccess = autoAccess;
        }

        #endregion Constructors
    }
}