﻿using AutoMapper;
using HIPS.PatientSchemas;

using AssistedRegistration = HIPS.Web.UI.ViewModels.AssistedRegistration;
using ConsentManagement = HIPS.Web.UI.ViewModels.ConsentManagement;
using DataIntegrity = HIPS.Web.UI.ViewModels.DataIntegrity;
using DisclosureManagement = HIPS.Web.UI.ViewModels.DisclosureManagement;
using DocumentManagement = HIPS.Web.UI.ViewModels.DocumentManagement;
using DocumentUpload = HIPS.Web.UI.ViewModels.DocumentUpload;
using PcehrView = HIPS.Web.UI.ViewModels.PcehrView;

namespace HIPS.Web.UI.Helpers.Mapping.Profiles
{
    /// <summary>
    /// AutoMapper mapping profile for the Patient entity.
    /// </summary>
    internal class PatientProfile : Profile
    {
        /// <summary>
        /// Returns the name of the mapping profile.
        /// </summary>
        public override string ProfileName
        {
            get { return this.GetType().Name; }
        }

        #region Methods

        /// <summary>
        /// Configures the maps available as part of this mapping profile.
        /// </summary>
        protected override void Configure()
        {
            // Data --> ViewModel:
            this.CreateMap<PatientInHospital, PcehrView.PatientViewModel>()
                .ForMember(dest => dest.DateOfBirth, opt => opt.MapFrom(src => src.DateOfBirth))
                .ForMember(dest => dest.HospitalName, opt => opt.MapFrom(src => src.HospitalName))
                .ForMember(dest => dest.IHI, opt => opt.MapFrom(src => src.Ihi))
                .ForMember(dest => dest.MRN, opt => opt.MapFrom(src => src.Mrn))
                .ForMember(dest => dest.Name, opt => opt.MapFrom(src => string.Format("{0}, {1}", src.FamilyName, src.GivenNames)))
                .ForMember(dest => dest.Ward, opt => opt.MapFrom(src => src.Ward))
                .ForMember(dest => dest.Room, opt => opt.MapFrom(src => src.Room))
                .ForMember(dest => dest.Bed, opt => opt.MapFrom(src => src.Bed));

            this.CreateMap<AdmittedPatient, PcehrView.PatientViewModel>()
                .ForMember(dest => dest.DateOfBirth, opt => opt.MapFrom(src => src.DateOfBirth))
                .ForMember(dest => dest.HospitalName, opt => opt.MapFrom(src => src.HospitalName))
                .ForMember(dest => dest.IHI, opt => opt.MapFrom(src => src.Ihi))
                .ForMember(dest => dest.MRN, opt => opt.MapFrom(src => src.Mrn))
                .ForMember(dest => dest.Name, opt => opt.MapFrom(src => string.Format("{0}, {1}", src.FamilyName, src.GivenNames)))
                .ForMember(dest => dest.Ward, opt => opt.MapFrom(src => src.Ward))
                .ForMember(dest => dest.Room, opt => opt.MapFrom(src => src.Room))
                .ForMember(dest => dest.Bed, opt => opt.MapFrom(src => src.Bed));

            this.CreateMap<PatientInHospital, DocumentUpload.PatientViewModel>()
                .ForMember(dest => dest.DateOfBirth, opt => opt.MapFrom(src => src.DateOfBirth))
                .ForMember(dest => dest.Name, opt => opt.MapFrom(src => string.Format("{0}, {1}", src.FamilyName, src.GivenNames)))
                .ForMember(dest => dest.Location, opt => opt.MapFrom(src => string.Format("{0}: {1}", src.Ward, src.Bed)))
                .ForMember(dest => dest.ParticipationStatus, opt => opt.MapFrom(src => src.ParticipationStatus));

            this.CreateMap<AdmittedPatient, DataIntegrity.PatientViewModel>()
                .ForMember(dest => dest.SexCode, opt => opt.MapFrom(src => src.CurrentSex))
                .ForMember(dest => dest.DateOfBirth, opt => opt.MapFrom(src => src.DateOfBirth))
                .ForMember(dest => dest.HospitalName, opt => opt.MapFrom(src => src.HospitalName))
                .ForMember(dest => dest.MedicareIrn, opt => opt.MapFrom(src => src.MedicareIrn))
                .ForMember(dest => dest.MedicareCardNumber, opt => opt.MapFrom(src => src.MedicareNumber))
                .ForMember(dest => dest.DvaFileNumber, opt => opt.MapFrom(src => src.DvaNumber))
                .ForMember(dest => dest.MRN, opt => opt.MapFrom(src => src.Mrn))
                .ForMember(dest => dest.Name, opt => opt.MapFrom(src => string.Format("{0}, {1}", src.FamilyName, src.GivenNames)))
                .ForMember(dest => dest.Ward, opt => opt.MapFrom(src => src.Ward))
                .ForMember(dest => dest.Room, opt => opt.MapFrom(src => src.Room))
                .ForMember(dest => dest.Bed, opt => opt.MapFrom(src => src.Bed));

            this.CreateMap<AdmittedPatient, ConsentManagement.PatientViewModel>()
                .ForMember(dest => dest.DateOfBirth, opt => opt.MapFrom(src => src.DateOfBirth))
                .ForMember(dest => dest.MRN, opt => opt.MapFrom(src => src.Mrn))
                .ForMember(dest => dest.Name, opt => opt.MapFrom(src => string.Format("{0}, {1}", src.FamilyName, src.GivenNames)))
                .ForMember(dest => dest.Ward, opt => opt.MapFrom(src => src.Ward))
                .ForMember(dest => dest.Room, opt => opt.MapFrom(src => src.Room))
                .ForMember(dest => dest.Bed, opt => opt.MapFrom(src => src.Bed))
                .ForMember(dest => dest.PcehrParticipationStatus, opt => opt.MapFrom(src => src.ParticipationStatus))
                .ForMember(dest => dest.PcehrDisclosed, opt => opt.MapFrom(src => src.PcehrDisclosed))
                .ForMember(dest => dest.ConsentWithdrawn, opt => opt.MapFrom(src => src.ConsentWithdrawn))
                .ForMember(dest => dest.EpisodeCount, opt => opt.MapFrom(src => src.EpisodeCount))
                .ForMember(dest => dest.EpisodeId, opt => opt.MapFrom(src => src.SourceSystemEpisodeId));

            this.CreateMap<AdmittedPatient, DisclosureManagement.PatientViewModel>()
                .ForMember(dest => dest.DateOfBirth, opt => opt.MapFrom(src => src.DateOfBirth))
                .ForMember(dest => dest.MRN, opt => opt.MapFrom(src => src.Mrn))
                .ForMember(dest => dest.Name, opt => opt.MapFrom(src => string.Format("{0}, {1}", src.FamilyName, src.GivenNames)))
                .ForMember(dest => dest.Ward, opt => opt.MapFrom(src => src.Ward))
                .ForMember(dest => dest.Room, opt => opt.MapFrom(src => src.Room))
                .ForMember(dest => dest.Bed, opt => opt.MapFrom(src => src.Bed))
                .ForMember(dest => dest.PcehrParticipationStatus, opt => opt.MapFrom(src => src.ParticipationStatus))
                .ForMember(dest => dest.PcehrDisclosed, opt => opt.MapFrom(src => src.PcehrDisclosed))
                .ForMember(dest => dest.ConsentWithdrawn, opt => opt.MapFrom(src => src.ConsentWithdrawn))
                .ForMember(dest => dest.EpisodeCount, opt => opt.MapFrom(src => src.EpisodeCount))
                .ForMember(dest => dest.EpisodeId, opt => opt.MapFrom(src => src.SourceSystemEpisodeId));

            this.CreateMap<AdmittedPatient, DocumentManagement.PatientViewModel>()
                .ForMember(dest => dest.DateOfBirth, opt => opt.MapFrom(src => src.DateOfBirth))
                .ForMember(dest => dest.MRN, opt => opt.MapFrom(src => src.Mrn))
                .ForMember(dest => dest.Name, opt => opt.MapFrom(src => string.Format("{0}, {1}", src.FamilyName, src.GivenNames)));

            this.CreateMap<AdmittedPatient, DocumentUpload.PatientViewModel>()
                .ForMember(dest => dest.FamilyName, opt => opt.MapFrom(src => src.FamilyName))
                .ForMember(dest => dest.GivenNames, opt => opt.MapFrom(src => src.GivenNames))
                .ForMember(dest => dest.DateOfBirth, opt => opt.MapFrom(src => src.DateOfBirth))
                .ForMember(dest => dest.Mrn, opt => opt.MapFrom(src => src.Mrn))
                .ForMember(dest => dest.Ward, opt => opt.MapFrom(src => src.Ward))
                .ForMember(dest => dest.Room, opt => opt.MapFrom(src => src.Room))
                .ForMember(dest => dest.Bed, opt => opt.MapFrom(src => src.Bed))
                .ForMember(dest => dest.ParticipationStatus, opt => opt.MapFrom(src => src.ParticipationStatus));

            this.CreateMap<PatientInHospital, AssistedRegistration.UnregisteredPatientViewModel>()
                .ForMember(dest => dest.HospitalId, opt => opt.MapFrom(src => src.HospitalCode))
                .ForMember(dest => dest.FamilyName, opt => opt.MapFrom(src => src.RegisteredFamilyName))
                .ForMember(dest => dest.GivenNames, opt => opt.MapFrom(src => src.RegisteredGivenName))
                .ForMember(dest => dest.Ihi, opt => opt.MapFrom(src => src.Ihi))
                .ForMember(dest => dest.Mrn, opt => opt.MapFrom(src => src.Mrn))
                .ForMember(dest => dest.DateOfBirth, opt => opt.MapFrom(src => src.DateOfBirth))
                .ForMember(dest => dest.Ward, opt => opt.MapFrom(src => src.Ward))
                .ForMember(dest => dest.Room, opt => opt.MapFrom(src => src.Room))
                .ForMember(dest => dest.Bed, opt => opt.MapFrom(src => src.Bed));

            this.CreateMap<AdmittedPatient, AssistedRegistration.PersonDemographicViewModel>()
                .ForMember(dest => dest.FamilyName, opt => opt.MapFrom(src => src.FamilyName))
                .ForMember(dest => dest.GivenNames, opt => opt.MapFrom(src => src.GivenNames))
                .ForMember(dest => dest.MedicareNumber, opt => opt.MapFrom(src => src.MedicareNumber))
                .ForMember(dest => dest.MedicareNumberIrn, opt => opt.MapFrom(src => src.MedicareIrn))
                .ForMember(dest => dest.DvaFileNumber, opt => opt.MapFrom(src => src.DvaNumber))
                .ForMember(dest => dest.DateOfBirth, opt => opt.MapFrom(src => src.DateOfBirth))
                .ForMember(dest => dest.Ihi, opt => opt.MapFrom(src => src.Ihi))
                .ForMember(dest => dest.Mrn, opt => opt.MapFrom(src => src.Mrn))
                .ForMember(dest => dest.SexCode, opt => opt.MapFrom(src => src.CurrentSex));

            this.CreateMap<PatientInHospital, AssistedRegistration.PersonDemographicViewModel>()
                .ForMember(dest => dest.FamilyName, opt => opt.MapFrom(src => src.FamilyName))
                .ForMember(dest => dest.GivenNames, opt => opt.MapFrom(src => src.GivenNames))
                .ForMember(dest => dest.MedicareNumber, opt => opt.MapFrom(src => src.MedicareNumber))
                .ForMember(dest => dest.MedicareNumberIrn, opt => opt.MapFrom(src => src.MedicareIrn))
                .ForMember(dest => dest.DvaFileNumber, opt => opt.MapFrom(src => src.DvaNumber))
                .ForMember(dest => dest.DateOfBirth, opt => opt.MapFrom(src => src.DateOfBirth))
                .ForMember(dest => dest.Ihi, opt => opt.MapFrom(src => src.Ihi))
                .ForMember(dest => dest.Mrn, opt => opt.MapFrom(src => src.Mrn))
                .ForMember(dest => dest.SexCode, opt => opt.MapFrom(src => src.CurrentSex));
        }

        #endregion Methods
    }
}