﻿using System;

namespace HIPS.Web.UI.ViewModels.DocumentManagement
{
    /// <summary>
    /// View model for displaying the contents of a particular document.
    /// </summary>
    public class DocumentContentViewModel : DocumentManagementViewModelBase
    {
        #region Properties

        /// <summary>
        /// Gets or sets the URL for the document to be displayed.
        /// </summary>
        public string DocumentUrl { get; set; }

        /// <summary>
        /// Gets or sets the date and time the document was uploaded.
        /// </summary>
        public DateTime? UploadTimestamp { get; set; }

        #endregion Properties

        #region Calculated Properties

        /// <summary>
        /// Gets an informational message that explains that this is a document
        /// that was uploaded to the PCEHR system on a certain date.
        /// </summary>
        public string UploadedInfo
        {
            get
            {
                string prefix = "The following document is displayed as uploaded to the PCEHR";
                if (this.UploadTimestamp.HasValue)
                {
                    return string.Format("{0} on {1}. ", prefix, this.UploadTimestamp.Value.ToString("d/M/yyyy"));
                }
                else
                {
                    return string.Format("{0}. ", prefix);
                }
            }
        }

        #endregion Calculated Properties
    }
}