﻿using System.ComponentModel.DataAnnotations;
using HIPS.Web.UI.ViewModels.Shared;

namespace HIPS.Web.UI.ViewModels.DocumentManagement
{
    /// <summary>
    /// Base view model to be used with the document management feature.
    /// </summary>
    public class DocumentManagementViewModelBase
    {
        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="DocumentManagementViewModelBase" /> class.
        /// </summary>
        public DocumentManagementViewModelBase()
        {
            this.Messages = new ViewMessageList();
        }

        #endregion Constructors

        #region Properties

        /// <summary>
        /// Gets or sets the list of messages associated with the view model.
        /// </summary>
        public ViewMessageList Messages { get; set; }

        /// <summary>
        /// Gets or sets the identifier associated with the selected hospital.
        /// </summary>
        [Required]
        [Display(Name = "Hospital")]
        public string HospitalId { get; set; }

        /// <summary>
        /// Gets or sets the currently selected hospital.
        /// </summary>
        public HospitalViewModel CurrentHospital { get; set; }

        /// <summary>
        /// Gets or sets the identifier associated with the selected patient.
        /// </summary>
        public string PatientId { get; set; }

        /// <summary>
        /// Gets or sets the currently selected patient.
        /// </summary>
        public PatientViewModel CurrentPatient { get; set; }

        /// <summary>
        /// Gets or sets the identifier associated with the selected document.
        /// </summary>
        public string SetId { get; set; }

        /// <summary>
        /// Gets or sets the currently selected document.
        /// </summary>
        public UploadedDocumentViewModel CurrentDocument { get; set; }

        #endregion Properties

        #region Methods

        /// <summary>
        /// Determines if the view model contains a selected hospital.
        /// </summary>
        /// <returns>Boolean. true if the view model contains a selected hospital, false otherwise.</returns>
        public bool IsHospitalSelected()
        {
            return !string.IsNullOrEmpty(this.HospitalId);
        }

        #endregion Methods
    }
}