﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;

namespace HIPS.Web.UI.ViewModels.PcehrView
{
    /// <summary>
    /// View model for providing a summary for a selected patient.
    /// </summary>
    public class PatientSummaryViewModel : PcehrViewModelBase
    {
        #region Properties

        [Required(ErrorMessage = "'From' date is required.")]
        [Display(Name = "From"), DisplayFormat(DataFormatString = "dd/MM/yyyy HH:mm")]
        public DateTime? FromDate { get; set; }

        [Required(ErrorMessage = "'To' date is required.")]
        [Display(Name = "To"), DisplayFormat(DataFormatString = "dd/MM/yyyy HH:mm")]
        public DateTime? ToDate { get; set; }

        /// <summary>
        /// Determines whether the specified object is valid.
        /// </summary>
        /// <returns>
        /// A collection that holds failed-validation information.
        /// </returns>
        /// <param name="validationContext">The validation context.</param>
        public IEnumerable<ValidationResult> Validate(ValidationContext validationContext)
        {
            if (ToDate.HasValue && ToDate.Value.Date > DateTime.Today)
            {
                yield return new ValidationResult("'To' date cannot be in the future.");
            }
            if (ToDate.HasValue && FromDate.HasValue && FromDate.Value.Date > ToDate.Value.Date)
            {
                yield return new ValidationResult("'To' date must be after the 'From' date.");
            }
        }


        /// <summary>
        /// Gets or sets the document categories for the documents available for a selected patient.
        /// </summary>
        public List<DocumentCategoryViewModel> DocumentCategories { get; internal set; }

        /// <summary>
        /// Gets or sets the list of documents for a selected patient.
        /// </summary>
        public List<DocumentViewModel> Documents { get; internal set; }

        /// <summary>
        /// Gets or sets the count of prescription and dispense documents for a selected patient.
        /// </summary>
        public int PrescriptionDispenseDocumentCount { get; internal set; }

        #endregion Properties

        #region Constructors

        /// <summary>
        /// Constructor.
        /// </summary>
        public PatientSummaryViewModel()
        {
            this.DocumentCategories = new List<DocumentCategoryViewModel>();
            this.Documents = new List<DocumentViewModel>();
        }

        #endregion Constructors
    }
}