﻿using AutoMapper;

using CommonSchema = HIPS.CommonSchemas;
using ServiceSchema = HIPS.ServiceContracts.Common.DTO;

namespace HIPS.Web.Data.Hips.Mapping.Profiles
{
    internal class PatientProfile : Profile
    {
        public override string ProfileName
        {
            get
            {
                return this.GetType().Name;
            }
        }

        protected override void Configure()
        {
            // Common --> Service
            this.CreateMap<CommonSchema.PatientIdentifier.Mrn, ServiceSchema.PatientIdentifier.Mrn>();

            this.CreateMap<CommonSchema.PatientIdentifier.RegisteredEnterprisePatient, ServiceSchema.PatientIdentifier.RegisteredEnterprisePatient>();

            // Service --> Common
            this.CreateMap<ServiceSchema.PatientEpisode, HIPS.Web.Model.Common.PatientEpisode>();

            this.CreateMap<ServiceSchema.LocalClinicalDocumentMetaData, HIPS.Web.Model.Common.LocalClinicalDocumentMetaData>();

            this.CreateMap<HIPS.ServiceContracts.Common.DTO.PatientIdentifier.Mrn, HIPS.CommonSchemas.PatientIdentifier.PatientIdentifierBase>()
                .As<HIPS.CommonSchemas.PatientIdentifier.Mrn>();

            this.CreateMap<HIPS.ServiceContracts.Common.DTO.PatientIdentifier.RegisteredEnterprisePatient, HIPS.CommonSchemas.PatientIdentifier.PatientIdentifierBase>()
                .As<HIPS.CommonSchemas.PatientIdentifier.RegisteredEnterprisePatient>();
        }
    }
}