using System.Collections.Generic;
using System.Linq;
using HIPS.Web.Model.AssistedRegistration;
using HIPS.Web.Model.Common;
using HIPS.Web.ModelInterface.AssistedRegistration;
using HIPS.Web.ModelInterface.Common;
using HIPS.Web.ModelInterface.DischargeSummary;

namespace HIPS.Web.Data.WebsiteDb
{
    public class WebsiteDbRepository : IAssistedRegistrationReferenceRepository, IDischargeSummaryReferenceRepository, ISettingsRepository
    {
        private WebsiteDbContext Database { get; set; }

        public WebsiteDbRepository()
        {
            Database = new WebsiteDbContext();
        }

        #region Assisted Registration Entities

        public List<IdentityVerificationMethod> GetIdentityVerificationMethods()
        {
            return Database.IdentityVerificationMethods.Where(i => i.IsEnabled).OrderBy(i => i.DisplayOrder).ToList();
        }

        public List<IndigenousStatus> GetIndigenousStatuses()
        {
            return Database.IndigenousStatuses.OrderBy(i => i.DisplayOrder).ToList();
        }

        public List<IvcDeliveryMethod> GetIvcDeliveryMethods()
        {
            return Database.IvcDeliveryMethods.Where(i => i.IsEnabled).OrderBy(i => i.DisplayOrder).ToList();
        }

        public List<MedicareConsent> GetMedicareConsents()
        {
            // This ordering does not address parent/child nested ordering
            return Database.MedicareConsents.Where(i => i.IsEnabled).OrderBy(i => i.DisplayOrder).ToList();
        }

        public List<Sex> GetSexes()
        {
            return Database.Sexes.OrderBy(i => i.Description).ToList();
        }

        #endregion Assisted Registration Entities

        #region Discharge Summary Entities

        public List<ClinicalSpecialty> GetClinicalSpecialties()
        {
            return this.Database.ClinicalSpecialties.OrderBy(c => c.Description).ToList();
        }

        #endregion Discharge Summary Entities

        #region Settings Entities

        public List<Setting> GetSettings()
        {
            return Database.Settings.ToList();
        }

        #endregion Settings Entities

        public void Dispose()
        {
            if (Database != null)
            {
                Database.Dispose();
                Database = null;
            }
        }
    }
}