﻿using System;
using System.Web;

namespace HIPS.Web.Components.Web
{
    /// <summary>
    /// Represents a minimal implementation of an HttpContext.
    /// </summary>
    [Serializable]
    public class FakeHttpContext : HttpContextBase
    {
        #region Private Members

        private HttpRequestBase mRequest;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets the HttpRequest associated with this HttpContext.
        /// </summary>
        public override HttpRequestBase Request
        {
            get
            {
                return this.mRequest;
            }
        }

        #endregion Properties

        #region Constructors

        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="request"></param>
        public FakeHttpContext(HttpRequestBase request)
        {
            this.mRequest = request;
        }

        #endregion Constructors
    }

    /// <summary>
    /// Represents a minimal implementation of an HttpRequest.
    /// </summary>
    [Serializable]
    public class FakeHttpRequest : HttpRequestBase
    {
        #region Private Members

        private string mAppRelativeCurrentExecutionFilePath;
        private string mPathInfo;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets the AppRelativeCurrentExecutionFilePath.
        /// </summary>
        public override string AppRelativeCurrentExecutionFilePath
        {
            get
            {
                return this.mAppRelativeCurrentExecutionFilePath;
            }
        }

        /// <summary>
        /// Gets the PathInfo.
        /// </summary>
        public override string PathInfo
        {
            get
            {
                return this.mPathInfo;
            }
        }

        #endregion Properties

        #region Constructors

        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="appRelativeCurrentExecutionFilePath"></param>
        /// <param name="pathInfo"></param>
        public FakeHttpRequest(string appRelativeCurrentExecutionFilePath, string pathInfo)
        {
            this.mAppRelativeCurrentExecutionFilePath = appRelativeCurrentExecutionFilePath;
            this.mPathInfo = pathInfo;
        }

        #endregion Constructors
    }
}