﻿using AutoMapper;

using CommonSchema = HIPS.Web.Model;
using ServiceSchema = HIPS.ServiceContracts.Common.DTO;

namespace HIPS.Web.Data.Hips.Mapping.Profiles
{
    internal class PatientIdentifierProfile : Profile
    {
        public override string ProfileName
        {
            get { return this.GetType().Name; }
        }

        protected override void Configure()
        {
            // Service --> Common
            this.CreateMap<ServiceSchema.PatientIdentifier.Mrn, CommonSchema.PatientIdentifier.PatientIdentifierBase>()
                .As<CommonSchema.PatientIdentifier.Mrn>();

            this.CreateMap<ServiceSchema.PatientIdentifier.Mrn, CommonSchema.PatientIdentifier.Mrn>();

            // Common --> Service
            this.CreateMap<CommonSchema.PatientIdentifier.Mrn, ServiceSchema.PatientIdentifier.Mrn>();
            this.CreateMap<CommonSchema.PatientIdentifier.Mrn, HIPS.CommonSchemas.PatientIdentifier.Mrn>();
        }
    }
}