﻿using System;

using HIPS.Web.Model.ParticipatingIndividual;

namespace HIPS.Web.Model.Cda
{
    public class CdaHeaderMetadata
    {
        /// <summary>
        /// Gets or sets an <see cref="ParticipatingIndividual" /> object that represents
        /// the person who is the 'Author' for the document.
        /// </summary>
        public ParticipatingProvider DocumentAuthor { get; set; }

        /// <summary>
        /// Gets or sets an <see cref="ParticipatingIndividual" /> object that represents
        /// the person who is the 'Responsible Health Professional at Time of
        /// Discharge' for the document.
        /// </summary>
        public ParticipatingProvider ResponsibleHealthProfessional { get; set; }

        /// <summary>
        /// Gets or sets the admission date and time. This is when the patient visit started.
        /// This date and time should match an existing episode supplied in the HL7 feed.
        /// If there is no matching episode, and the patient identifier is a ValidatedIhi,
        /// an episode stub will be created. If there is no matching episode, and the patient
        /// identifier is a different type, an error will be returned.
        /// </summary>
        public DateTime AdmissionDateTime { get; set; }

        /// <summary>
        /// Gets or sets the discharge date and time. This is when the patient visit ended or is planned to end.
        /// </summary>
        public DateTime DischargeDateTime { get; set; }

        /// <summary>
        /// Gets or sets the clinical specialty or hospital department in which the patient was treated before discharge.
        /// </summary>
        public string Specialty { get; set; }

        /// <summary>
        /// Gets or sets a code that represents the status of the patient at the time of discharge and the place to which the person was or will be released.
        /// </summary>
        public ModeOfSeparation ModeOfSeparation { get; set; }

        /// <summary>
        /// Gets or sets the document creation date and time. This should be the
        /// date and time when this version of the document was completed, not
        /// when work on it started.
        /// </summary>
        public DateTime DocumentCreationDateTime { get; set; }

        /// <summary>
        /// Gets or sets the status of this version of the document, which may
        /// be either Interim (draft), Final (complete) or Withdrawn (recalled
        /// by the authoring organisation).
        /// </summary>
        public SourceDocumentStatus SourceDocumentStatus { get; set; }
    }
}