namespace HIPS.Web.Model.Common
{
    /// <summary>
    /// Represents a Hospital.
    /// </summary>
    public class Hospital
    {
        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="Hospital" /> class.
        /// </summary>
        public Hospital()
        {
        }

        /// <summary>
        /// Initialises a new instance of the <see cref="Hospital" /> class.
        /// </summary>
        /// <param name="hospitalFacilityCode">Hospital facility code.</param>
        /// <param name="hospitalFacilityCodeSystem">Hospital facility code system.</param>
        public Hospital(string hospitalFacilityCode, string hospitalFacilityCodeSystem)
            : this(hospitalFacilityCode, hospitalFacilityCodeSystem, null, null, null)
        {
        }

        /// <summary>
        /// Initialises a new instance of the <see cref="Hospital" /> class.
        /// </summary>
        /// <param name="hospitalFacilityCode">Hospital facility code.</param>
        /// <param name="hospitalFacilityCodeSystem">Hospital facility code system.</param>
        /// <param name="hospitalName">Hospital name.</param>
        /// <param name="hpio">HPI-O of the hospital.</param>
        /// <param name="hpioName">HPI-O name of the hospital.</param>
        public Hospital(string hospitalFacilityCode, string hospitalFacilityCodeSystem, string hospitalName, string hpio, string hpioName)
        {
            this.HospitalFacilityCode = hospitalFacilityCode;
            this.HospitalFacilityCodeSystem = hospitalFacilityCodeSystem;
            this.HospitalName = hospitalName;
            this.Hpio = hpio;
            this.HpioName = hpioName;
        }

        #endregion Constructors

        #region Properties

        /// <summary>
        /// Gets or sets the Hospital name.
        /// </summary>
        public string HospitalName { get; set; }

        /// <summary>
        /// Gets or sets the HPI-O of the hospital.
        /// </summary>
        public string Hpio { get; set; }

        /// <summary>
        /// Gets or sets the HPI-O name of the hospital.
        /// </summary>
        public string HpioName { get; set; }

        /// <summary>
        /// Gets or sets the Hospital Facility Code.
        /// </summary>
        public string HospitalFacilityCode { get; set; }

        /// <summary>
        /// Gets or sets the Hospital Facility Code System.
        /// </summary>
        public string HospitalFacilityCodeSystem { get; set; }

        /// <summary>
        /// Gets or sets the HPI-O logo of the hospital.
        /// </summary>
        public byte[] HpioLogo { get; set; }

        #endregion Properties
    }
}