﻿namespace HIPS.Web.Model
{
    /// <summary>
    /// Status of the document process for upload and remove
    /// </summary>
    public enum LocalDocumentStatus
    {
        /// <summary>
        ///
        /// </summary>
        Unknown = 0,

        /// <summary>
        ///
        /// </summary>
        PendingUpload = 1,

        /// <summary>
        ///
        /// </summary>
        Uploaded = 2,

        /// <summary>
        ///
        /// </summary>
        FailedUpload = 3,

        /// <summary>
        ///
        /// </summary>
        PendingRemove = 4,

        /// <summary>
        ///
        /// </summary>
        Removed = 5,

        /// <summary>
        ///
        /// </summary>
        FailedRemove = 6
    }

    /// <summary>
    /// Represents the file type and semantics of an attachment.
    /// </summary>
    public enum AttachmentType
    {
        /// <summary>
        /// No value has been supplied. This represents an invalid invocation of the web service.
        /// </summary>
        None = 0,

        /// <summary>
        /// Represents an additional JPEG image attached to the document. This image will be shown
        /// in the CDA body under the main document. This file must be a JPEG image.
        /// </summary>
        AttachedImageJpeg = 1,

        /// <summary>
        /// Represents an additional PNG image attached to the document. This image will be shown
        /// in the CDA body under the main document. This file must be a PNG image.
        /// </summary>
        AttachedImagePng = 2,

        /// <summary>
        /// Represents an additional TIFF image attached to the document. This image will be shown
        /// in the CDA body under the main document. This file must be a TIFF image.
        /// </summary>
        AttachedImageTiff = 3,

        /// <summary>
        /// Represents an additional GIF image attached to the document. This image will be shown
        /// in the CDA body under the main document. This file must be a GIF image.
        /// </summary>
        AttachedImageGif = 4,

        /// <summary>
        /// Represents an additional linked document. This will be linked from the body of the
        /// CDA document. This file must be a PDF document.
        /// </summary>
        AttachedDocumentPdf = 5,

        /// <summary>
        /// Represents the organisational logo that will appear in the header of the CDA document.
        /// This file must be a PNG image. If no attachment is supplied with this type, and there
        /// is a logo in the database Hospital table, then HIPS will include the logo from the
        /// database.
        /// </summary>
        OrganisationalLogoPng = 6,
    }

    /// <summary>
    /// Represents the status of the patient at the time of discharge and the
    /// place to which the person was or will be released. The valid codes
    /// are defined in AIHW 270094 titled "Episode of admitted patient care-
    /// separation mode, code N". Shorter, more user friendly display names
    /// were developed by NEHTA.
    /// </summary>
    public enum ModeOfSeparation
    {
        /// <summary>
        /// No value has been supplied. This represents an invalid invocation of the web service.
        /// </summary>
        None = 0,

        /// <summary>
        /// Represents a discharge or transfer to an acute hospital.
        /// </summary>
        AcuteHospital = 1,

        /// <summary>
        /// Represents a discharge or transfer to a residential aged care service, unless this is the usual place of residence.
        /// </summary>
        AgedCareService = 2,

        /// <summary>
        /// Represents a discharge or transfer to a psychiatric hospital.
        /// </summary>
        PsychiatricCare = 3,

        /// <summary>
        /// Represents a discharge or transfer to other health care accommodation (includes mothercraft hospitals)
        /// </summary>
        OtherHealthService = 4,

        /// <summary>
        /// Represents a statistical discharge - type change.
        /// </summary>
        AdministrativeDischarge = 5,

        /// <summary>
        /// Represents that the patient left against medical advice or was discharged at own risk.
        /// </summary>
        SelfDischarge = 6,

        /// <summary>
        /// Represents a statistical discharge from leave.
        /// </summary>
        AdministrativeFromLeave = 7,

        /// <summary>
        /// Represents that the patient died.
        /// </summary>
        Deceased = 8,

        /// <summary>
        /// Represents that the patient was discharged to his/her usual residence, own accommodation or a welfare institution (includes prisons, hostels and group homes providing primarily welfare services).
        /// </summary>
        Home = 9,
    }

    /// <summary>
    /// Represents the status of this version of the document as communicated
    /// by the source system. The valid codes are defined by NCTIS titled
    /// "Admin Codes - Document Status".
    /// </summary>
    public enum SourceDocumentStatus
    {
        /// <summary>
        /// No value has been supplied. This represents an invalid invocation of the web service.
        /// </summary>
        None = 0,

        /// <summary>
        /// Represents an interim or draft version of the document. Interim versions are not normally
        /// uploaded to the PCEHR system.
        /// </summary>
        Interim = 1,

        /// <summary>
        /// Represents a final version of the document. This may be the first final version or an amendment.
        /// </summary>
        Final = 2,

        /// <summary>
        /// Represents a notification that the document has been withdrawn by the authoring organisation.
        /// Withdrawn versions are intended for delivery to point-to-point (P2P) recipients of the document
        /// and are not normally uploaded to the PCEHR system. Instead the document can be removed from the
        /// PCEHR system with a separate web service invocation.
        /// </summary>
        Withdrawn = 3,
    }

    /// <summary>
    /// Represents the status of a HPI-I
    /// </summary>
    public enum HpiiStatus
    {
        /// <summary>
        /// No further action.
        /// </summary>
        Active,

        /// <summary>
        /// A warning should be raised in HPI-I search if Retired HPii Status is returned.
        /// </summary>
        Retired,

        /// <summary>
        /// A warning should be raised in HPI-I search if Deactivated Hpii Status is returned.
        /// </summary>
        Deactivated,

        /// <summary>
        /// An alert or a warning is raised in HPI-I search if Resolved Hpii Status is returned.
        /// </summary>
        Resolved
    }
}