﻿using System;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.Web.Components.ServiceModel;

namespace HIPS.Web.ModelInterface.ConsentManagement
{
    /// <summary>
    /// Defines the operations to be supported by an implementation of a consent management service.
    /// </summary>
    public interface IConsentManagementService : IDisposable
    {
        /// <summary>
        /// Records a patient's withdrawal or reinstatement of consent to upload documents for a particular episode.
        /// </summary>
        /// <param name="consentWithdrawn">Boolean value indicating whether to record withdrawal (true) or reinstatement (false) of consent.</param>
        /// <param name="notes">Notes entered by the user.</param>
        /// <param name="patientIdentifier">The MRN that identifies the patient at the hospital.</param>
        /// <param name="admissionDate">The admission date that identifies which episode the consent should be recorded against.</param>
        /// <param name="user">The identity of the user who is operating the application.</param>
        /// <returns>A service response that indicates whether the operation was successful or not.</returns>
        ServiceResponse<bool> RecordConsent(bool consentWithdrawn, string notes, Mrn patientIdentifier, DateTime admissionDate, CommonSchemas.UserDetails user);

        /// <summary>
        /// Records a patient's disclosure or removal of disclosure of the existence of a PCEHR.
        /// </summary>
        /// <param name="pcehrDisclosed">Boolean value indicating whether to record disclosure (true) or removal of disclosure (false).</param>
        /// <param name="notes">Notes entered by the user.</param>
        /// <param name="patientIdentifier">The MRN that identifies the patient at the hospital.</param>
        /// <param name="userDetails">The identity of the user who is operating the application.</param>
        /// <returns>A service response that indicates whether the operation was successful or not.</returns>
        ServiceResponse<bool> RecordDisclosure(bool pcehrDisclosed, string notes, Mrn patientIdentifier, CommonSchemas.UserDetails userDetails);
    }
}