﻿using AutoMapper;
using HIPS.PatientSchemas;

using ConsentManagement = HIPS.Web.UI.ViewModels.ConsentManagement;
using DocumentUpload = HIPS.Web.UI.ViewModels.DocumentUpload;

namespace HIPS.Web.UI.Helpers.Mapping.Profiles
{
    /// <summary>
    /// AutoMapper mapping profile for the episode entity.
    /// </summary>
    public class EpisodeProfile : Profile
    {
        /// <summary>
        /// Returns the name of the mapping profile.
        /// </summary>
        public override string ProfileName
        {
            get { return this.GetType().Name; }
        }

        #region Methods

        /// <summary>
        /// Configures the mappings from data transfer objects (DTO) to view models for episode entities.
        /// </summary>
        protected override void Configure()
        {
            this.CreateMap<PatientEpisode, ConsentManagement.EpisodeViewModel>()
               .ForMember(dest => dest.AdmissionDate, opt => opt.MapFrom(src => src.AdmissionDate))
               .ForMember(dest => dest.AdmissionReason, opt => opt.MapFrom(src => src.AdmissionReason))
               .ForMember(dest => dest.ConsentWithdrawn, opt => opt.MapFrom(src => src.ConsentWithdrawn))
               .ForMember(dest => dest.DischargeDate, opt => opt.MapFrom(src => src.DischargeDate))
               .ForMember(dest => dest.ResponsibleProviderFamilyName, opt => opt.MapFrom(src => src.ResponsibleProviderFamilyName))
               .ForMember(dest => dest.ResponsibleProviderGivenNames, opt => opt.MapFrom(src => src.ResponsibleProviderGivenNames))
               .ForMember(dest => dest.ResponsibleProviderSuffix, opt => opt.MapFrom(src => src.ResponsibleProviderSuffix))
               .ForMember(dest => dest.ResponsibleProviderTitle, opt => opt.MapFrom(src => src.ResponsibleProviderTitle));

            this.CreateMap<EpisodePatientDetailsResponse, ConsentManagement.EpisodeViewModel>()
               .ForMember(dest => dest.AdmissionDate, opt => opt.MapFrom(src => src.AdmissionDate))
               .ForMember(dest => dest.AdmissionReason, opt => opt.MapFrom(src => src.AdmissionReason))
               .ForMember(dest => dest.ConsentWithdrawn, opt => opt.MapFrom(src => src.ConsentWithdrawn))
               .ForMember(dest => dest.DischargeDate, opt => opt.MapFrom(src => src.DischargeDate))
               .ForMember(dest => dest.ResponsibleProviderFamilyName, opt => opt.MapFrom(src => src.ResponsibleProviderFamilyName))
               .ForMember(dest => dest.ResponsibleProviderGivenNames, opt => opt.MapFrom(src => src.ResponsibleProviderGivenNames))
               .ForMember(dest => dest.ResponsibleProviderSuffix, opt => opt.MapFrom(src => src.ResponsibleProviderSuffix))
               .ForMember(dest => dest.ResponsibleProviderTitle, opt => opt.MapFrom(src => src.ResponsibleProviderTitle))
               .ForMember(dest => dest.Bed, opt => opt.MapFrom(src => src.Bed))
               .ForMember(dest => dest.Ward, opt => opt.MapFrom(src => src.Ward))
               .ForMember(dest => dest.Room, opt => opt.MapFrom(src => src.Room))
               .ForMember(dest => dest.WithdrawalAuditInformation, opt => opt.MapFrom(src => src.WithdrawalAuditInformation))
               .ForMember(dest => dest.SourceSystemEpisodeId, opt => opt.MapFrom(src => src.SourceSystemEpisodeId));

            this.CreateMap<EpisodePatientDetailsResponse, DocumentUpload.EpisodeViewModel>()
                .ForMember(dest => dest.AdmissionDate, opt => opt.MapFrom(src => src.AdmissionDate))
                .ForMember(dest => dest.AdmissionReason, opt => opt.MapFrom(src => src.AdmissionReason))
                .ForMember(dest => dest.DischargeDate, opt => opt.MapFrom(src => src.DischargeDate))
                .ForMember(dest => dest.Ward, opt => opt.MapFrom(src => src.Ward))
                .ForMember(dest => dest.Room, opt => opt.MapFrom(src => src.Room))
                .ForMember(dest => dest.Bed, opt => opt.MapFrom(src => src.Bed))
                .ForMember(dest => dest.ResponsibleProviderIdentifier, opt => opt.MapFrom(src => src.ResponsibleProviderIdentifier))
                .ForMember(dest => dest.ResponsibleProviderFamilyName, opt => opt.MapFrom(src => src.ResponsibleProviderFamilyName))
                .ForMember(dest => dest.ResponsibleProviderGivenNames, opt => opt.MapFrom(src => src.ResponsibleProviderGivenNames))
                .ForMember(dest => dest.ResponsibleProviderSuffix, opt => opt.MapFrom(src => src.ResponsibleProviderSuffix))
                .ForMember(dest => dest.ResponsibleProviderTitle, opt => opt.MapFrom(src => src.ResponsibleProviderTitle))
                .ForMember(dest => dest.SourceSystemEpisodeId, opt => opt.MapFrom(src => src.SourceSystemEpisodeId));

            //this.CreateMap<EpisodePatientDetailsResponse, DocumentUpload.UploadDocumentViewModel>()
            //    .ForMember(dest => dest.AdmissionDate, opt => opt.MapFrom(src => src.AdmissionDate))
            //    .ForMember(dest => dest.AdmissionReason, opt => opt.MapFrom(src => src.AdmissionReason))
            //    .ForMember(dest => dest.DischargeDate, opt => opt.MapFrom(src => src.DischargeDate))
            //    .ForMember(dest => dest.ResponsibleProviderIdentifier, opt => opt.MapFrom(src => src.ResponsibleProviderIdentifier))
            //    .ForMember(dest => dest.ResponsibleProviderFamilyName, opt => opt.MapFrom(src => src.ResponsibleProviderFamilyName))
            //    .ForMember(dest => dest.ResponsibleProviderGivenNames, opt => opt.MapFrom(src => src.ResponsibleProviderGivenNames))
            //    .ForMember(dest => dest.ResponsibleProviderSuffix, opt => opt.MapFrom(src => src.ResponsibleProviderSuffix))
            //    .ForMember(dest => dest.ResponsibleProviderTitle, opt => opt.MapFrom(src => src.ResponsibleProviderTitle));
            //    //.ForMember(dest => dest.SourceSystemEpisodeId, opt => opt.MapFrom(src => src.SourceSystemEpisodeId));
        }

        #endregion Methods
    }
}