﻿using System;
using System.Collections.Generic;
using System.Linq;
using HIPS.Web.Model.Common;

namespace HIPS.Web.UI.Helpers
{
    public static class SettingsExtensions
    {
        public static string GetSettingValue(this List<Setting> settings, Setting.SettingCodes code)
        {
            return GetSettingValue(settings, code.ToString());
        }

        public static string GetSettingValue(this List<Setting> settings, string code)
        {
            if (settings == null)
            {
                throw new InvalidOperationException("Could not load settings.");
            }

            Setting found = settings.SingleOrDefault(s => s.Code.Equals(code, StringComparison.OrdinalIgnoreCase));

            if (found == null)
            {
                throw new InvalidOperationException(string.Format("Could not load required setting ('{0}').", code));
            }

            return found.Value;
        }
    }
}