﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web.Mvc;
using HIPS.Web.Model.AssistedRegistration;

namespace HIPS.Web.UI.ViewModels.AssistedRegistration
{
    public class MedicareConsentViewModel
    {
        #region Properties

        [Display(Name = "Medicare Access Consent")]
        public bool MedicareConsentAll { get; set; }

        [Display(Name = "Medicare Access Consent")]
        public Dictionary<string, bool> MedicareConsents { get; set; }

        #endregion Properties

        #region Data Source Properties

        public List<KeyValuePair<SelectListItem, List<SelectListItem>>> MedicareConsentOptions { get; internal set; }

        #endregion Data Source Properties

        public MedicareConsentViewModel()
        {
            MedicareConsents = new Dictionary<string, bool>();
            MedicareConsentOptions = new List<KeyValuePair<SelectListItem, List<SelectListItem>>>();
        }

        public Dictionary<MedicareConsent, bool> GetMedicareConsents(List<MedicareConsent> consentOptions)
        {
            // If all consented, return all
            if (MedicareConsentAll)
            {
                return consentOptions.ToDictionary(c => c, c => true);
            }

            Dictionary<MedicareConsent, bool> consented = new Dictionary<MedicareConsent, bool>();

            if (MedicareConsents != null)
            {
                foreach (KeyValuePair<string, bool> specifiedConsent in MedicareConsents)
                {
                    MedicareConsent option = consentOptions.FirstOrDefault(o => o.Code == specifiedConsent.Key);

                    if (option == null)
                    {
                        throw new ApplicationException(string.Format("Medicare Consent specified for unknown code ({0})", specifiedConsent.Key));
                    }

                    // Add option
                    consented.Add(option, specifiedConsent.Value);
                }
            }

            return consented;
        }
    }
}