using System.Collections.Generic;

using HIPS.Web.UI.ViewModels.Shared;

namespace HIPS.Web.UI.ViewModels.AssistedRegistration
{
    /// <summary>
    /// View model for displaying unregistered patients.
    /// </summary>
    public class UnregisteredViewModel
    {
        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="UnregisteredViewModel" /> class.
        /// </summary>
        public UnregisteredViewModel()
        {
            this.UnregisteredPatients = new List<UnregisteredPatientViewModel>();
            this.Messages = new ViewMessageList();
        }

        #endregion Constructors

        #region Properties

        /// <summary>
        /// Gets the list of unregistered patients for a selected hospital.
        /// </summary>
        public List<UnregisteredPatientViewModel> UnregisteredPatients { get; internal set; }

        /// <summary>
        /// Gets or sets the list of messages associated with the view model.
        /// </summary>
        public ViewMessageList Messages { get; set; }

        #endregion Properties
    }
}