﻿using System.ComponentModel.DataAnnotations;
using System.Web.Mvc;

namespace HIPS.Web.UI.ViewModels.ConsentManagement
{
    /// <summary>
    /// View model for the form for administering a request to withdraw or reinstate consent to upload documents for a selected episode.
    /// </summary>
    public class WithdrawConsentViewModel : ConsentManagementViewModelBase
    {
        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="WithdrawConsentViewModel" /> class.
        /// </summary>
        /// <param name="hospitalId">The hospital identifier.</param>
        /// <param name="patientId">The patient identifier.</param>
        /// <param name="episodeId">The episode identifier.</param>
        public WithdrawConsentViewModel(string hospitalId, string patientId, string episodeId)
        {
            this.HospitalId = hospitalId;
            this.PatientId = patientId;
            this.EpisodeId = episodeId;
        }

        /// <summary>
        /// Initialises a new instance of the <see cref="WithdrawConsentViewModel" /> class.
        /// Parameter-less constructor required for System.Web.Mvc.DefaultModelBinder to create model.
        /// </summary>
        public WithdrawConsentViewModel()
        {
        }

        #endregion Constructors

        #region Properties

        /// <summary>
        /// Gets or sets the notes entered by the user.
        /// </summary>
        [Required]
        [Display(Name = "Reference Notes")]
        [AllowHtml]
        [MaxLength(5000, ErrorMessage = "The maximum length for Reference Notes is 5000 characters.")]
        public string Notes { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether the user has checked the confirmation checkbox.
        /// </summary>
        [Required]
        public bool Confirm { get; set; }

        /// <summary>
        /// Gets or sets the number of documents that have been uploaded to the
        /// PCEHR for this episode and not yet removed. Withdrawal of consent
        /// can only be recorded when this value is zero.
        /// </summary>
        public int UploadedDocumentCount { get; set; }

        #endregion Properties
    }
}