﻿using System.Collections.Generic;

namespace HIPS.Web.UI.ViewModels.DocumentUpload
{
    /// <summary>
    /// View model containing a list of episodes, for the user to select an episode, to upload or supersede discharge summary documents.
    /// </summary>
    public class EpisodesViewModel : DocumentUploadViewModelBase
    {
        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="EpisodesViewModel" /> class.
        /// </summary>
        public EpisodesViewModel()
        {
            this.Episodes = new List<EpisodeViewModel>();
        }

        #endregion Constructors

        #region Properties

        /// <summary>
        /// Gets or sets a list of episodes from which the user may select one.
        /// </summary>
        public List<EpisodeViewModel> Episodes { get; set; }

        #endregion Properties
    }
}