﻿using System;

namespace HIPS.Web.UI.ViewModels.PcehrView
{
    /// <summary>
    /// View model for a particular document.
    /// </summary>
    public class DocumentViewModel
    {
        #region Properties

        /// <summary>
        /// Gets or sets the creation date of the document.
        /// </summary>
        public DateTime CreationDate { get; set; }

        /// <summary>
        /// Gets or sets the identifier of the organisation that created the document.
        /// </summary>
        public string Organisation { get; set; }

        /// <summary>
        /// Gets or sets the author of the document.
        /// </summary>
        public string Author { get; set; }

        /// <summary>
        /// Gets or sets the unique identifier of the repository containing the document.
        /// </summary>
        public string RepositoryId { get; set; }

        /// <summary>
        /// Gets or sets the unique identifier of the document.
        /// </summary>
        public string DocumentId { get; set; }

        /// <summary>
        /// Gets or sets the service start date of the document.
        /// </summary>
        public DateTime ServiceStartDate { get; set; }

        /// <summary>
        /// Gets or sets the service end date of the document.
        /// </summary>
        public DateTime ServiceEndDate { get; set; }

        /// <summary>
        /// Gets or sets the document category code.
        /// </summary>
        public string CategoryCode { get; set; }

        /// <summary>
        /// Gets or sets the document category description.
        /// </summary>
        public string CategoryName { get; set; }

        #endregion Properties
    }
}