﻿using System.ComponentModel.DataAnnotations;

namespace HIPS.Web.UI.ViewModels.Shared
{
    /// <summary>
    /// View model for a particular hospital.
    /// </summary>
    public class HospitalViewModel
    {
        #region Properties

        /// <summary>
        /// Gets or sets the code system code of the hospital.
        /// </summary>
        public string CodeSystemCode { get; set; }

        /// <summary>
        /// Gets or sets the code of the hospital.
        /// </summary>
        public string Code { get; set; }

        /// <summary>
        /// Gets or sets the name of the hospital.
        /// </summary>
        [Display(Name = "Hospital")]
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the HPI-O of the hospital.
        /// </summary>
        public string Hpio { get; set; }

        /// <summary>
        /// Gets or sets the HPI-O name of the hospital.
        /// </summary>
        public string HpioName { get; set; }

        /// <summary>
        /// Gets or sets the HPI-O logo in a byte array of the hospital.
        /// </summary>
        public byte[] HpioLogo { get; set; }

        #endregion Properties
    }
}