﻿using System;
using System.Collections.Generic;

namespace HIPS.Web.Model.Common
{
    public class PatientEpisode
    {
        /// <summary>
        /// The patient's MRN at the hospital where the patient was admitted.
        /// </summary>
        public string Mrn { get; set; }

        /// <summary>
        /// The admission date of the patient.
        /// </summary>
        public DateTime AdmissionDate { get; set; }

        /// <summary>
        /// The discharge date of the patient.
        /// </summary>
        public DateTime? DischargeDate { get; set; }

        /// <summary>
        /// The family name of the patient's responsible provider.
        /// </summary>
        public string ResponsibleProviderFamilyName { get; set; }

        /// <summary>
        /// The given names of the patient's responsible provider.
        /// </summary>
        public string ResponsibleProviderGivenNames { get; set; }

        /// <summary>
        /// The title of the patient's responsible provider (such as 'Dr', 'Ms' or 'Mr').
        /// </summary>
        public string ResponsibleProviderTitle { get; set; }

        /// <summary>
        /// The suffix of the patient's responsible provider (such as 'Jr' or 'Sr')
        /// </summary>
        public string ResponsibleProviderSuffix { get; set; }

        /// <summary>
        /// Whether or not the consent has been withdrawn
        /// </summary>
        public bool? ConsentWithdrawn { get; set; }

        /// <summary>
        /// The admission reason of the patient
        /// </summary>
        public string AdmissionReason { get; set; }

        /// <summary>
        /// The source system episode id or visit number, specific to the hospital
        /// </summary>
        public string SourceSystemEpisodeId { get; set; }

        public List<LocalClinicalDocumentMetaData> LocalClinicalDocumentMetaData { get; set; }
    }
}