﻿namespace HIPS.Web.Model.Identity
{
    /// <summary>
    /// Represents an end-user within a local directory (such as Active Directory).
    /// </summary>
    public class LocalUser
    {
        #region Properties

        /// <summary>
        /// Gets or sets the HPI-O of the health provider organisation upon whose behalf the end-user is accessing P2P.
        /// </summary>
        public string AccessingHpio { get; set; }

        /// <summary>
        /// Gets or sets the family name of the user.
        /// </summary>
        public virtual string FamilyName { get; set; }

        /// <summary>
        /// Gets or sets the given name(s) of the user.
        /// </summary>
        public virtual string GivenNames { get; set; }

        /// <summary>
        /// Gets or sets the name of the login (account) of the user within the local directory.
        /// </summary>
        public virtual string Login { get; set; }

        /// <summary>
        /// Gets or sets the name of the directory domain of the user within the local directory.
        /// </summary>
        public virtual string Domain { get; set; }

        #endregion Properties
    }
}