﻿using System;
using System.Collections.Generic;
using HIPS.PcehrDataStore.Schemas;
using HIPS.Web.Components.Cache;

namespace HIPS.Web.ModelInterface.Common
{
    public class CachedHospitalRepository : IHospitalRepository
    {
        private IHospitalRepository ReferenceRepository { get; set; }

        private ICacheProvider CacheProvider { get; set; }

        private readonly string CacheKeyFormat;

        public CachedHospitalRepository(IHospitalRepository referenceRepository, ICacheProvider cacheProvider, string cacheKeyPrefix = "")
        {
            ReferenceRepository = referenceRepository;
            CacheProvider = cacheProvider;
            CacheKeyFormat = cacheKeyPrefix + ".CachedHospitalRepository.{0}";
        }

        public List<Hospital> GetHospitals(string hospitalCodeSystem)
        {
            return CacheProvider.GetOrSet(String.Format(CacheKeyFormat, String.Format("GetHospitals(HospitalCodeSystem: {0})", hospitalCodeSystem)),
                                     () => ReferenceRepository.GetHospitals(hospitalCodeSystem));
        }

        public List<Hospital> GetAccessibleHospitals(List<string> accessibleGroupNames, string securityGroupCodeSystem)
        {
            return CacheProvider.GetOrSet(String.Format(CacheKeyFormat, String.Format("GetAccessibleHospitals(accessibleGroupNames: {0}, securityGroupCodeSystem: {1})", string.Join(",", accessibleGroupNames), securityGroupCodeSystem)),
                                     () => ReferenceRepository.GetAccessibleHospitals(accessibleGroupNames, securityGroupCodeSystem)); 
        }
        /// <summary>
        /// Performs application-defined tasks associated with freeing, releasing, or resetting unmanaged resources.
        /// </summary>
        public void Dispose()
        {
            if (ReferenceRepository != null)
            {
                ReferenceRepository.Dispose();
                ReferenceRepository = null;
            }
        }
    }
}