﻿using System;
using System.Collections.Generic;

using HIPS.Web.Components.ServiceModel;

using CommonSchema = HIPS.Web.Model;

namespace HIPS.Web.ModelInterface.PcehrView
{
    /// <summary>
    /// Defines the operations to be supported by an implementation of a Cda repository.
    /// </summary>
    public interface ICdaRepository : IDisposable
    {
        /// <summary>
        /// Creates a CDA discharge summary document that wraps a PDF document body.
        /// This may be for the purpose of uploading the discharge summary to the
        /// PCEHR or for provider-to-provider (P2P) secure message delivery (SMD).
        /// This takes in the PDF document, required metadata, and any attachments
        /// and creates a CDA document before packaging it.
        /// </summary>
        /// <param name="patientIdentifier">Identifier for the patient.</param>
        /// <param name="metadata">The data that is required to be added to finalise the CDA document.</param>
        /// <param name="attachments">The attached files (GIF, JPEG, PNG, TIFF or PDF) that will be referenced by the CDA document.
        /// Note that it is not necessary to include organisation logo file in the array because HIPS can automatically add the logo
        /// that is configured in the Hospital table of the PCEHR Data Store.</param>
        /// <param name="pdfDocument">PDF discharge summary document.</param>
        /// <param name="userContext">User requesting the operation.</param>
        /// <returns>CdaDocumentDetails containing the results of the operation.</returns>
        ServiceResponse<CommonSchema.Cda.CdaDocumentDetails> CreateDischargeSummaryLevel1A(
            CommonSchema.PatientIdentifier.Mrn patientIdentifier,
            CommonSchema.Cda.CdaHeaderMetadata metadata,
            List<CommonSchema.Cda.CdaAttachment> attachments,
            byte[] pdfDocument,
            CommonSchema.Identity.LocalUser userContext);
    }
}