using System.Web.Optimization;

namespace HIPS.Web.UI
{
    /// <summary>
    /// Bundle configuration.
    /// </summary>
    public class BundleConfig
    {
        /// <summary>
        /// Registers the bundles.
        /// For more information on Bundling, visit http://go.microsoft.com/fwlink/?LinkId=254725
        /// </summary>
        /// <param name="bundles">Collection of bundles.</param>
        public static void RegisterBundles(BundleCollection bundles)
        {
            // TODO: Include this in Dev Guide
            // Bundle names for scripts should be in the form ~/bundles/script
            // Bundles names for styles must be more specific
            // - They should match the actual virtual folder path if possible, at least in levels of hierarchy (e.g. ~/Content/css/something)
            // - They should not however match an actual file or folder (e.g. not ~/Content/css)
            // Neither styles nor scripts should use a file extension for the bundle name.

            // jQuery
            bundles.Add(new ScriptBundle("~/bundles/jquery").Include("~/Scripts/jquery-{version}.js", "~/Scripts/spin.js", "~/Scripts/jquery.spin.js", "~/Scripts/Custom/jquery.helpers.js", "~/Scripts/jquery.backgroundSize.js"));

            // jQuery Validation
            bundles.Add(new ScriptBundle("~/bundles/jquery.validation").Include("~/Scripts/jquery.unobtrusive*", "~/Scripts/jquery.validate*", "~/Scripts/Custom/jquery.validate*"));

            // TODO: Check requirement for this
            // Use the development version of Modernizr to develop with and learn from. Then, when you're
            // ready for production, use the build tool at http://modernizr.com to pick only the tests you need.
            bundles.Add(new ScriptBundle("~/bundles/modernizr").Include("~/Scripts/modernizr-*"));

            // DataTables
            bundles.Add(new ScriptBundle("~/bundles/datatables").Include("~/Scripts/jquery.dataTables.min.js", "~/Scripts/jquery.dataTables.bootstrap.js", "~/Scripts/jquery.dataTables.ukDates.js", "~/Scripts/custom/jquery.dataTables*"));

            // Moment.js
            bundles.Add(new ScriptBundle("~/bundles/momentjs").Include("~/Scripts/moment.js", "~/Scripts/moment-with-locales.js"));

            // CSS (TODO: Probably remove at least nehta.css here, possibly datepicker to bootstrap too)
            bundles.Add(new StyleBundle("~/Content/css/css").Include("~/Content/css/datepicker.css", "~/Content/css/bootstrap-datetimepicker.css", "~/Content/css/nehta.css"));

            // Bootstrap
            BundleTable.Bundles.Add(new ScriptBundle("~/bundles/bootstrap").Include("~/Scripts/bootstrap*"));
            BundleTable.Bundles.Add(new StyleBundle("~/Content/themes/theme/bootstrap").Include("~/Content/themes/nehta/bootstrap.css"));
        }
    }
}