﻿using System.Reflection;

namespace HIPS.Web.UI.Helpers
{
    /// <summary>
    /// Provides information about the application.
    /// </summary>
    public class AppInfo
    {
        #region Fields

        public static readonly string PublicVersion;
        public static readonly string InternalVersion;

        #endregion Fields

        #region Constructors

        /// <summary>
        /// Constructor.
        /// </summary>
        static AppInfo()
        {
            var assemblyVersion = Assembly.GetExecutingAssembly().GetName().Version;
            var productVersion = Assembly.GetExecutingAssembly().GetCustomAttribute<AssemblyInformationalVersionAttribute>().InformationalVersion;

            PublicVersion = productVersion;
            InternalVersion = assemblyVersion.ToString();
        }

        #endregion Constructors
    }
}