﻿using System.Net;
using System.Security.Principal;
using System.Web;
using System.Web.Mvc;
using MvcAuthorization;

namespace HIPS.Web.UI.Helpers
{
    public class AuthenticateThenAuthorizeOrThrowFilter : AuthorizeFilter
    {
        protected override bool AuthorizeCore(HttpContextBase httpContext)
        {

            if (httpContext.Handler != null && !(httpContext.Handler is WindowsLoginHandler))
            {
                return base.AuthorizeCore(httpContext);
            }

            // TODO: Support for resolving authentication of non MVC Handler, e.g. Cache retrieval
            return true;
        }

        protected override void HandleUnauthorizedRequest(AuthorizationContext filterContext)
        {
            IPrincipal user = filterContext.HttpContext.User;

            // Unauthenticated
            if (!user.Identity.IsAuthenticated)
            {
                filterContext.Result = new HttpUnauthorizedResult();
                return;
            }

            // Forbidden (insufficient access)
            filterContext.Result = new HttpStatusCodeResult(HttpStatusCode.Forbidden);
        }
    }
}