$(function ($) {
    $.validator.setDefaults({
        // Bug fix to jquery.validation to not show validation errors on initial field fill
        onkeyup: function (element, event) {
            if (event.which === 9 && this.elementValue(element) === '') {
                return;
            } else if (element.name in this.submitted /* || element === this.lastActive */) {
                this.element(element);
            }
        },
        // Updated highlight for Bootstrap 3
        highlight: function (element, errorClass, validClass) {
            if (element == null) {
                /* If error below, have bound a ModelState error for a non-existent field */
                console.log('Attempt to highlight non-existent element');
                return;
            }

            if (element.type === 'radio') {
                this.findByName(element.name).addClass(errorClass).removeClass(validClass);
            } else {
                $(element).addClass(errorClass).removeClass(validClass);
                // Don't show success
                // $(element).closest('.form-group').removeClass('has-success').addClass('has-error');
                $(element).closest('.form-group').addClass('has-error');
            }
        },
        // Updated unhighlight for Bootstrap 3
        unhighlight: function (element, errorClass, validClass) {
            if (element == null) {
                /* If error below, have bound a ModelState error for a non-existent field */
                console.log('Attempt to highlight non-existent element');
                return;
            }

            if (element.type === 'radio') {
                this.findByName(element.name).removeClass(errorClass).addClass(validClass);
            } else {
                $(element).removeClass(errorClass).addClass(validClass);
                // Don't show success
                //$(element).closest('.form-group').removeClass('has-error').addClass('has-success');
                $(element).closest('.form-group').removeClass('has-error');
            }
        }
    });

    // Bug fix for jquery.Validation to allow en-AU date validation
    // Integrated with Bootstrap datepicker's parseDate but could be replaced with others
    // See: http://forums.asp.net/post/5102828.aspx
    // See: http://stackoverflow.com/a/10344219/364
    $.validator.methods.date = function (value, element) {
        if (this.optional(element)) {
            return true;
        };

        try {
            $.fn.datepicker.DPGlobal.parseDate(value, 'dd/mm/yyyy', 'en');
            return true;
        } catch (err) {
            alert(err);
            return false;
        }
    };

    // Add "mandatory" as a validation rule type for required checkboxes.
    $.validator.unobtrusive.adapters.addBool("mandatory", "required");

    // File extension validator
    $.validator.addMethod('fileextensions', function (value, element, param) {
        if (this.optional(element)) {
            return true;
        }

        var extension = getFileExtension(value).toUpperCase();
        var validExtension = $.inArray(extension, param.extensions) !== -1;

        return validExtension;
    });

    $.validator.unobtrusive.adapters.add('fileextensions', ['ext'], function (options) {
        var params = { extensions: options.params.ext.toUpperCase().split('|') };
        options.rules['fileextensions'] = params;

        if (options.message) {
            options.messages['fileextensions'] = options.message;
        }
    })

    function getFileExtension(fileName) {
        var extension = (/[.]/.exec(fileName)) ? /[^.]+$/.exec(fileName) : undefined;

        if (extension != undefined) {
            return extension[0];
        }
        return extension;
    };

    // File size validator
    $.validator.addMethod('filesize', function (value, element, param) {
        if (this.optional(element)) {
            return true;
        }

        var min = param.min;
        var max = param.max;
        var fileApiSupported = window.File && window.FileReader && window.FileList && window.Blob;

        if (fileApiSupported) {
            var files = $(element)[0].files;

            for (var i = 0; i < files.length; i++) {
                var file = files[i];

                return file.size >= min && file.size <= max;
            }
        }

        return true;
    });

    $.validator.unobtrusive.adapters.add('filesize', ['min', 'max'], function (options) {
        var params = { min: options.params.min, max: options.params.max };
        options.rules['filesize'] = params;

        if (options.message) {
            options.messages['filesize'] = options.message;
        }
    });   

    // Luhn Check Digit validator
    $.validator.addMethod('luhncheck', function (value, element, param) {
        if (this.optional(element)) {
            return true;
        }

        if ($.type(value) == "string") {
            var healthIdentifierWithLuhnCheckDigit = value.replace(' ', '').replace('-', '');
            value = healthIdentifierWithLuhnCheckDigit;

            if (healthIdentifierWithLuhnCheckDigit.length > 15) {
                value = healthIdentifierWithLuhnCheckDigit.substring(0, 15);
            }

            var result = calculateLuhnCheckDigit(value) == healthIdentifierWithLuhnCheckDigit;

            return result;
        }

        return false;
    });

    $.validator.unobtrusive.adapters.addBool('luhncheck');

    function calculateLuhnCheckDigit(value) {
        var result;
        var num = 0;
        var flag = true;

        if (value == null) {
            return "INVALID Health Identifier - null value";
        }

        value = value.replace(' ', '').replace('-', '');
        if (value.length == 15) {

            for (var i = 14; i >= 0; i--) {
                var num2 = parseInt(value.substr(i, 1));               
                    
                if (flag) {
                    num2 = num2 * 2;
                    if (num2 > 9) {
                        num2 = num2 - 9;
                    }
                }

                flag = !flag;
                num = num + num2;
            }
            
            var num3 = parseInt(num.toString().substr(num.toString().length - 1, 1));
            
            if (num3 > 0) {
                num3 = 10 - num3;
            }
            
            result = value + num3;
            
            return result;
        }

        return "INVALID Health Identifier - must be 15 digits : " + value;
    }

}(jQuery));