﻿namespace HIPS.Web.UI.ViewModels.Common
{
    /// <summary>
    /// View model for the "Session Information" action.
    /// </summary>
    public class SessionInfoViewModel
    {
        #region Properties

        /// <summary>
        /// Gets or sets the display name of the currently logged in user.
        /// </summary>
        public string User { get; set; }



        /// <summary>
        /// Gets or sets the display name of the currently selected health provider organisation.
        /// </summary>
        public string Hpo { get; set; }


        /// <summary>
        /// Gets or sets the number of Hpo's the user has access to
        /// </summary>
        public int NumberHpoAccessible { get; set; }

        /// <summary>
        /// Gets or sets the user's profile image Uri
        /// </summary>
        public string UserProfileImageUri { get; set; }

        /// <summary>
        /// Gets or sets the Hpo Logo into an array of bytes
        /// </summary>
        public byte[] HpoLogoArray { get; set; }

        #endregion Properties
    }
}