﻿using System;

namespace HIPS.Web.UI.ViewModels.DocumentManagement
{
    /// <summary>
    /// View model for a particular patient.
    /// </summary>
    public class PatientViewModel
    {
        #region Properties

        /// <summary>
        /// Gets or sets the name of the patient.
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the date of birth of the patient.
        /// </summary>
        public DateTime DateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the MRN of the patient.
        /// </summary>
        public string MRN { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether the patient has disclosed the existence of their PCEHR.
        /// </summary>
        public bool PcehrDisclosed { get; set; }

        /// <summary>
        /// Gets or sets whether the patient has withdrawn consent to upload documents for their most recent episode.
        /// </summary>
        public bool? ConsentWithdrawn { get; set; }

        /// <summary>
        /// Gets or sets the admission date and time of the patient's most recent episode.
        /// </summary>
        public DateTime AdmissionDate { get; set; }

        /// <summary>
        /// Gets or sets the admission reason of the patient's most recent episode.
        /// </summary>
        public string AdmissionReason { get; set; }

        /// <summary>
        /// Gets or sets the discharge date and time of the patient's most recent episode.
        /// </summary>
        public DateTime? DischargeDate { get; set; }

        /// <summary>
        /// Gets or sets the family name of the responsible provider of the patient's most recent episode.
        /// </summary>
        public string ResponsibleProviderFamilyName { get; set; }

        /// <summary>
        /// Gets or sets the given names of the responsible provider of the patient's most recent episode.
        /// </summary>
        public string ResponsibleProviderGivenNames { get; set; }

        /// <summary>
        /// Gets or sets the name suffix of the responsible provider of the patient's most recent episode.
        /// </summary>
        public string ResponsibleProviderSuffix { get; set; }

        /// <summary>
        /// Gets or sets the name title of the responsible provider of the patient's most recent episode.
        /// </summary>
        public string ResponsibleProviderTitle { get; set; }

        #region Calculated Properties

        /// <summary>
        /// Gets the name of the responsible provider for the patient's most recent episode.
        /// </summary>
        public string ResponsibleProvider
        {
            get
            {
                return string.Format("{0} {1} {2} {3}", this.ResponsibleProviderTitle, this.ResponsibleProviderGivenNames, this.ResponsibleProviderFamilyName, this.ResponsibleProviderSuffix);
            }
        }

        #endregion Calculated Properties

        #endregion Properties
    }
}