﻿using System.ComponentModel.DataAnnotations;
using System.Web.Mvc;

using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.Web.UI.ViewModels.DocumentManagement
{
    /// <summary>
    /// View model for the form for removing a document from the PCEHR system.
    /// </summary>
    public class RemoveDocumentViewModel : DocumentManagementViewModelBase
    {
        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="RemoveDocumentViewModel" /> class.
        /// </summary>
        /// <param name="hospitalId">Identifier of the selected hospital.</param>
        /// <param name="patientId">Identifier of the selected patient.</param>
        /// <param name="setId">Identifier of the selected document.</param>
        public RemoveDocumentViewModel(string hospitalId, string patientId, string setId)
        {
            this.HospitalId = hospitalId;
            this.PatientId = patientId;
            this.SetId = setId;
        }

        /// <summary>
        /// Initialises a new instance of the <see cref="RemoveDocumentViewModel" /> class.
        /// </summary>
        public RemoveDocumentViewModel()
        {
        }

        #endregion Constructors

        #region Properties

        /// <summary>
        /// Gets or sets the reason for removal.
        /// </summary>
        [Required]
        [Display(Name = "Removal Reason")]
        public RemovalReason Reason { get; set; }

        /// <summary>
        /// Gets or sets the notes entered by the user.
        /// </summary>
        [Required]
        [Display(Name = "Reference Notes")]
        [AllowHtml]
        [MaxLength(5000, ErrorMessage = "The maximum length for Reference Notes is 5000 characters.")]
        public string Notes { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether the user has checked the confirmation checkbox.
        /// </summary>
        [Required]
        public bool Confirm { get; set; }

        #endregion Properties
    }
}