﻿using System.Collections.Generic;

namespace HIPS.Web.UI.ViewModels.DocumentManagement
{
    /// <summary>
    /// View model for a list of uploaded documents for a selected patient.
    /// </summary>
    public class UploadedDocumentsViewModel : DocumentManagementViewModelBase
    {
        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="UploadedDocumentsViewModel" /> class.
        /// </summary>
        public UploadedDocumentsViewModel()
        {
            this.UploadedDocuments = new List<UploadedDocumentViewModel>();
            this.IsIhiValid = true;
        }

        #endregion Constructors

        #region Properties

        /// <summary>
        /// Gets or sets the list of uploaded documents.
        /// </summary>
        public List<UploadedDocumentViewModel> UploadedDocuments { get; set; }

        /// <summary>
        /// Gets or sets if the Ihi returned is valid.
        /// </summary>
        public bool IsIhiValid { get; set; }

        #endregion Properties
    }
}