﻿using System.ComponentModel.DataAnnotations;

using HIPS.Web.Components.Validation;

namespace HIPS.Web.UI.ViewModels.DocumentUpload
{
    /// <summary>
    /// View model for document authors.
    /// </summary>
    public class UserViewModel
    {
        /// <summary>
        /// Gets or sets author's User Id.
        /// </summary>
        [Required]
        [Display(Name = "User ID")]
        public string UserID { get; set; }

        /// <summary>
        /// Gets or sets author's HPI-I.
        /// </summary>
        [Display(Name = "HPI-I")]
        [LuhnCheckDigitValidator]
        public string HpiI { get; set; }

        /// <summary>
        /// Gets or sets author's Given names.
        /// </summary>
        [Required]
        [Display(Name = "Given Name")]
        public string GivenNames { get; set; }

        /// <summary>
        /// Gets or sets author's Family name.
        /// </summary>
        [Required]
        [Display(Name = "Family Name")]
        public string FamilyName { get; set; }
    }
}