﻿using System.Collections.Generic;

namespace HIPS.Web.UI.ViewModels.PcehrView
{
    /// <summary>
    /// View model for providing a summary for a selected patient.
    /// </summary>
    public class PatientSummaryViewModel : PcehrViewModelBase
    {
        #region Properties

        /// <summary>
        /// Gets or sets the document categories for the documents available for a selected patient.
        /// </summary>
        public List<DocumentCategoryViewModel> DocumentCategories { get; internal set; }

        /// <summary>
        /// Gets or sets the list of documents for a selected patient.
        /// </summary>
        public List<DocumentViewModel> Documents { get; internal set; }

        /// <summary>
        /// Gets or sets the count of prescription and dispense documents for a selected patient.
        /// </summary>
        public int PrescriptionDispenseDocumentCount { get; internal set; }

        #endregion Properties

        #region Constructors

        /// <summary>
        /// Constructor.
        /// </summary>
        public PatientSummaryViewModel()
        {
            this.DocumentCategories = new List<DocumentCategoryViewModel>();
            this.Documents = new List<DocumentViewModel>();
        }

        #endregion Constructors
    }
}