﻿using System.Collections.Generic;
using System.Linq;
using System.Web.Mvc;

namespace HIPS.Web.UI.ViewModels.PcehrView
{
    /// <summary>
    /// View model for selecting a hospital and displaying its current patients.
    /// </summary>
    public class PatientsViewModel : PcehrViewModelBase
    {
        #region Properties

        /// <summary>
        /// Gets or sets the list of hospitals available for selection.
        /// </summary>
        public IEnumerable<SelectListItem> Hospitals { get; internal set; }

        /// <summary>
        /// Gets or sets the list of patients for a selected hospital.
        /// </summary>
        public List<PatientViewModel> Patients { get; internal set; }

        #endregion Properties

        #region Constructors

        /// <summary>
        /// Constructor.
        /// </summary>
        public PatientsViewModel()
        {
            this.Hospitals = Enumerable.Empty<SelectListItem>();
            this.Patients = new List<PatientViewModel>();
        }

        #endregion Constructors
    }
}