﻿using HIPS.Web.Components.Common;

namespace HIPS.Web.UI.ViewModels.Shared
{
    /// <summary>
    /// Represents a textual message to be displayed by a view.
    /// </summary>
    public class ViewMessage
    {
        #region Properties

        /// <summary>
        /// Gets or sets the level associated with the message.
        /// </summary>
        public MessageLevel Level { get; set; }

        /// <summary>
        /// Gets or sets the description text for the message.
        /// </summary>
        public string Description { get; set; }

        #endregion Properties

        #region Constructors

        /// <summary>
        /// Constructor.
        /// </summary>
        public ViewMessage()
        {
        }

        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="description">Description text for the message.</param>
        /// <param name="level">Level associated with the message.</param>
        public ViewMessage(string description, MessageLevel level)
            : this()
        {
            this.Description = description;
            this.Level = level;
        }

        #endregion Constructors
    }
}