/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.utils.ElementChecker;
import com.sun.org.apache.xml.internal.security.utils.ElementProxy;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ElementCheckerImpl
implements ElementChecker {
    public boolean isNamespaceElement(Node node, String string2, String string3) {
        return node != null && string3 == node.getNamespaceURI() && node.getLocalName().equals(string2);
    }

    public static class EmptyChecker
    extends ElementCheckerImpl {
        public void guaranteeThatElementInCorrectSpace(ElementProxy elementProxy, Element element) throws XMLSecurityException {
        }
    }

    public static class FullChecker
    extends ElementCheckerImpl {
        public void guaranteeThatElementInCorrectSpace(ElementProxy elementProxy, Element element) throws XMLSecurityException {
            String string2 = elementProxy.getBaseLocalName();
            String string3 = elementProxy.getBaseNamespace();
            String string4 = element.getLocalName();
            String string5 = element.getNamespaceURI();
            if (!string3.equals(string5) || !string2.equals(string4)) {
                Object[] objectArray = new Object[]{string5 + ":" + string4, string3 + ":" + string2};
                throw new XMLSecurityException("xml.WrongElement", objectArray);
            }
        }
    }

    public static class InternedNsChecker
    extends ElementCheckerImpl {
        public void guaranteeThatElementInCorrectSpace(ElementProxy elementProxy, Element element) throws XMLSecurityException {
            String string2 = elementProxy.getBaseLocalName();
            String string3 = elementProxy.getBaseNamespace();
            String string4 = element.getLocalName();
            String string5 = element.getNamespaceURI();
            if (string3 != string5 || !string2.equals(string4)) {
                Object[] objectArray = new Object[]{string5 + ":" + string4, string3 + ":" + string2};
                throw new XMLSecurityException("xml.WrongElement", objectArray);
            }
        }
    }
}

